/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.resourceloader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.util.SpringUtils;

public class ResourceLoaderContainer
extends BaseLifecycle
implements ResourceLoader {
    private static final Logger LOG = LogManager.getLogger(ResourceLoaderContainer.class);
    private QName name;
    private List<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();

    public ResourceLoaderContainer(QName name) {
        this.name = name;
    }

    @Override
    public void start() throws Exception {
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            LOG.info("Starting ResourceLoader " + resourceLoader.getName());
            resourceLoader.start();
        }
        super.start();
    }

    @Override
    public void stop() throws Exception {
        while (!this.resourceLoaders.isEmpty()) {
            ResourceLoader rl = this.resourceLoaders.get(this.resourceLoaders.size() - 1);
            rl.stop();
            this.resourceLoaders.remove(rl);
        }
        super.stop();
        this.resourceLoaders.clear();
    }

    @Override
    public void addResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoaders.add(resourceLoader);
        this.moveKSBLoadersDownHack();
    }

    private void moveKSBLoadersDownHack() {
        for (int i = 0; i < this.resourceLoaders.size(); ++i) {
            boolean remote = this.resourceLoaders.get(i).getName().toString().toUpperCase().contains("KSB");
            if (!remote) continue;
            ResourceLoader removed = this.resourceLoaders.remove(i);
            this.resourceLoaders.add(this.resourceLoaders.size(), removed);
        }
    }

    @Override
    public void addResourceLoaderFirst(ResourceLoader resourceLoader) {
        this.resourceLoaders.add(0, resourceLoader);
        this.moveKSBLoadersDownHack();
    }

    public boolean containsResourceLoader(ResourceLoader resourceLoader) {
        return this.resourceLoaders.contains(resourceLoader);
    }

    @Override
    public ResourceLoader getResourceLoader(QName name) {
        if (this.getName().equals(name)) {
            return this;
        }
        for (ResourceLoader loader : this.resourceLoaders) {
            if (loader.getName().equals(name)) {
                return loader;
            }
            ResourceLoader loader2 = loader.getResourceLoader(name);
            if (loader2 == null) continue;
            return loader2;
        }
        return null;
    }

    @Override
    public List<QName> getResourceLoaderNames() {
        ArrayList<QName> names = new ArrayList<QName>();
        Iterator<ResourceLoader> iter = this.resourceLoaders.iterator();
        while (iter.hasNext()) {
            names.add(iter.next().getName());
        }
        return names;
    }

    public void removeAllResourceLoaders() {
        this.resourceLoaders.clear();
    }

    @Override
    public void removeResourceLoader(QName name) {
        Lifecycle loaderToRemove = null;
        for (ResourceLoader loader : this.resourceLoaders) {
            if (!loader.getName().equals(name)) continue;
            loaderToRemove = loader;
        }
        if (loaderToRemove != null) {
            try {
                loaderToRemove.stop();
            }
            catch (Exception e) {
                LOG.error("Failed to stop plugin " + loaderToRemove.getName() + " on removal", (Throwable)e);
            }
            this.resourceLoaders.remove(loaderToRemove);
        }
    }

    @Override
    public List<ResourceLoader> getResourceLoaders() {
        return this.resourceLoaders;
    }

    public Object getObject(ObjectDefinition definition) {
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            Object object = resourceLoader.getObject(definition);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object getService(QName qname) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ResourceLoader " + this.getName() + " fetching service " + qname);
        }
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            Object service;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Delegating fetch to " + this);
            }
            if (!SpringUtils.isNotNull(service = resourceLoader.getService(qname))) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found service from " + this);
            }
            return service;
        }
        return null;
    }

    @Override
    public String getContents(String indent, boolean servicePerLine) {
        String contents = indent + this + "\n";
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            contents = contents + resourceLoader.getContents(indent + "+++", servicePerLine);
        }
        return contents;
    }

    public String toString() {
        return "Resource Loader: " + this.name + " (" + ObjectUtils.identityToString((Object)this) + ") direct children resource loaders size: " + this.resourceLoaders.size();
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public void setName(QName name) {
        this.name = name;
    }
}

