/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.HsErrPid;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

public class HtmlHsErrPidReport
extends HtmlAbstractReport {
    private final List<HsErrPid> hsErrPidList;
    private final DateFormat dateTimeFormat = I18N.createDateAndTimeFormat();

    HtmlHsErrPidReport(List<HsErrPid> hsErrPidList, Writer writer) {
        super(writer);
        assert (hsErrPidList != null);
        this.hsErrPidList = hsErrPidList;
    }

    @Override
    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeTitle("alert.png", HtmlHsErrPidReport.getString("Crashes") + " (" + this.hsErrPidList.size() + ')');
        this.writeTable();
    }

    void writeTable() throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlHsErrPidReport.getString("Crashes"));
        this.write("<th>#File#</th>");
        this.write("<th class='sorttable_date'>#Date#</th>");
        for (HsErrPid hsErrPid : this.hsErrPidList) {
            table.nextRow();
            this.writeHsErrPid(hsErrPid);
        }
        table.endTable();
    }

    private void writeHsErrPid(HsErrPid hsErrPid) throws IOException {
        this.write("<td><a href='?part=crashes&path=");
        this.write(HtmlHsErrPidReport.urlEncode(hsErrPid.getFile().replace('\\', '/')));
        this.write("'>");
        this.write(HtmlHsErrPidReport.htmlEncode(hsErrPid.getFile()));
        this.write("</a>");
        String newColumnRight = "</td><td align='right'>";
        this.write("</td><td align='right'>");
        this.write(this.dateTimeFormat.format(hsErrPid.getDate()));
        this.write("</td>");
    }

    void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=crashes'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }
}

