/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.bus;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.registry.ServiceDescriptor;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.impl.bus.LazyEndpoint;
import org.kuali.rice.ksb.impl.bus.ServiceConfigurationSerializationHandler;

public final class RemoteService {
    private final ServiceInfo serviceInfo;
    private final ServiceRegistry serviceRegistry;
    private final Object endpointAcquisitionLock = new Object();
    private volatile Endpoint endpoint;

    public RemoteService(ServiceInfo serviceInfo, ServiceRegistry serviceRegistry) {
        RemoteService.validateServiceInfo(serviceInfo);
        if (serviceRegistry == null) {
            throw new IllegalArgumentException("serviceRegistry cannot be null");
        }
        this.serviceInfo = serviceInfo;
        this.serviceRegistry = serviceRegistry;
    }

    private static void validateServiceInfo(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            throw new IllegalArgumentException("serviceInfo cannot be null");
        }
        if (serviceInfo.getServiceId() == null) {
            throw new IllegalArgumentException("serviceInfo must have a serviceId but was null");
        }
    }

    public QName getServiceName() {
        return this.serviceInfo.getServiceName();
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getEndpoint() {
        Endpoint internalEndpoint = this.endpoint;
        if (internalEndpoint == null) {
            Object object = this.endpointAcquisitionLock;
            synchronized (object) {
                internalEndpoint = this.endpoint;
                if (internalEndpoint == null) {
                    this.endpoint = internalEndpoint = new LazyEndpoint(this.constructServiceConfiguration());
                }
            }
        }
        return internalEndpoint;
    }

    protected ServiceConfiguration constructServiceConfiguration() {
        ServiceDescriptor serviceDescriptor = this.serviceRegistry.getServiceDescriptor(this.serviceInfo.getServiceDescriptorId());
        if (serviceDescriptor == null) {
            throw new IllegalStateException("Failed to locate ServiceDescriptor for ServiceInfo with serviceDescriptorId=" + this.serviceInfo.getServiceDescriptorId());
        }
        if (StringUtils.isBlank((String)serviceDescriptor.getDescriptor())) {
            throw new IllegalStateException("ServiceDescriptor descriptor value is blank or null for descriptor with serviceEndpointId=" + this.serviceInfo.getServiceId());
        }
        return ServiceConfigurationSerializationHandler.unmarshallFromXml(serviceDescriptor.getDescriptor());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteService)) {
            return false;
        }
        return this.serviceInfo.equals((Object)((RemoteService)obj).getServiceInfo());
    }

    public int hashCode() {
        return this.serviceInfo.hashCode();
    }
}

