/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.hr.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.attr.CitizenshipType;
import org.kuali.coeus.common.framework.person.attr.KcPersonExtendedAttributes;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.hr.impl.AddressCollection;
import org.kuali.coeus.hr.impl.Affiliation;
import org.kuali.coeus.hr.impl.AffiliationCollection;
import org.kuali.coeus.hr.impl.AppointmentCollection;
import org.kuali.coeus.hr.impl.DegreeCollection;
import org.kuali.coeus.hr.impl.EmailCollection;
import org.kuali.coeus.hr.impl.Employment;
import org.kuali.coeus.hr.impl.EntityAddressBoAdapter;
import org.kuali.coeus.hr.impl.EntityAffiliationBoAdapter;
import org.kuali.coeus.hr.impl.EntityEmailBoAdapter;
import org.kuali.coeus.hr.impl.EntityEmploymentBoAdapter;
import org.kuali.coeus.hr.impl.EntityNameBoAdapter;
import org.kuali.coeus.hr.impl.EntityPhoneBoAdapter;
import org.kuali.coeus.hr.impl.HRImport;
import org.kuali.coeus.hr.impl.HRImportRecord;
import org.kuali.coeus.hr.impl.HRImportService;
import org.kuali.coeus.hr.impl.ImportError;
import org.kuali.coeus.hr.impl.ImportStatusService;
import org.kuali.coeus.hr.impl.KCExtendedAttributes;
import org.kuali.coeus.hr.impl.NameCollection;
import org.kuali.coeus.hr.impl.PersistableBoMergeAdapter;
import org.kuali.coeus.hr.impl.PersonAppointmentBoAdapter;
import org.kuali.coeus.hr.impl.PersonDegreeBoAdapter;
import org.kuali.coeus.hr.impl.PhoneCollection;
import org.kuali.coeus.sys.framework.auth.AuthServicePushService;
import org.kuali.coeus.sys.framework.auth.AuthServiceUserLoginFilter;
import org.kuali.coeus.sys.framework.auth.CoreUsersPushStatus;
import org.kuali.rice.core.api.cache.CacheManagerRegistry;
import org.kuali.rice.core.api.mo.common.Defaultable;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBase;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.kim.impl.identity.entity.EntityBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.identity.type.EntityTypeContactInfoBo;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component(value="hrImportService")
public class HRImportServiceImpl
implements HRImportService {
    private static final Logger LOG = LogManager.getLogger(HRImportServiceImpl.class);
    private static final String PERSON = "PERSON";
    private static final HashSet<String> runningImports = new HashSet();
    private Validator validator;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;
    @Autowired
    @Qualifier(value="cacheManagerRegistry")
    private CacheManagerRegistry cacheManagerRegistry;
    @Autowired
    @Qualifier(value="authServicePushService")
    private AuthServicePushService authServicePushService;
    @Autowired
    @Qualifier(value="importStatusService")
    private ImportStatusService statusService;
    @Autowired
    @Qualifier(value="entityAddressBoAdapter")
    private EntityAddressBoAdapter addressAdapter;
    @Autowired
    @Qualifier(value="entityAffiliationBoAdapter")
    private EntityAffiliationBoAdapter affiliationAdapter;
    @Autowired
    @Qualifier(value="entityEmailBoAdapter")
    private EntityEmailBoAdapter emailAdapter;
    @Autowired
    @Qualifier(value="entityEmploymentBoAdapter")
    private EntityEmploymentBoAdapter employmentAdapter;
    @Autowired
    @Qualifier(value="entityNameBoAdapter")
    private EntityNameBoAdapter nameAdapter;
    @Autowired
    @Qualifier(value="entityPhoneBoAdapter")
    private EntityPhoneBoAdapter phoneAdapter;
    @Autowired
    @Qualifier(value="personAppointmentBoAdapter")
    private PersonAppointmentBoAdapter appointmentAdapter;
    @Autowired
    @Qualifier(value="personDegreeBoAdapter")
    private PersonDegreeBoAdapter degreeAdapter;

    public HRImportServiceImpl() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    @Override
    public void setImportStatusService(ImportStatusService svc) {
        this.statusService = svc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRunning(String importId) {
        HashSet<String> hashSet = runningImports;
        synchronized (hashSet) {
            return runningImports.contains(importId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRunningImport(String importId) {
        HashSet<String> hashSet = runningImports;
        synchronized (hashSet) {
            runningImports.add(importId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopRunningImport(String importId) {
        HashSet<String> hashSet = runningImports;
        synchronized (hashSet) {
            runningImports.remove(importId);
        }
    }

    private HashSet<String> getAllIDs() {
        Collection allAttribs = this.legacyDataAdapter.findAll(KcPersonExtendedAttributes.class);
        HashSet<String> ids = new HashSet<String>();
        for (KcPersonExtendedAttributes attribs : allAttribs) {
            String id = attribs.getPersonId();
            if (ids.contains(id)) {
                LOG.warn("duplicate ID '" + id + "' found when getting all IDs");
                continue;
            }
            ids.add(id);
        }
        return ids;
    }

    protected void deactivatePeople(List<String> ids) {
        LOG.debug("deactivatePeople(final List<String> " + ids + ")");
        for (String id : ids) {
            if (id != null && !"".equals(id.trim())) {
                PrincipalBo principal = (PrincipalBo)this.legacyDataAdapter.findBySinglePrimaryKey(PrincipalBo.class, (Object)id);
                if (principal != null) {
                    LOG.debug("deactivating principal: " + id);
                    principal.setActive(false);
                    this.legacyDataAdapter.save((Object)principal);
                    continue;
                }
                LOG.warn("unable to find principal to deactivate with id: " + id);
                continue;
            }
            Error e = new Error("Ignoring blank principalId: '" + id + "'");
            LOG.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void flushCache() {
        LOG.debug("flushCache()");
        CacheManager manager = this.getCacheManagerRegistry().getCacheManager("kimDistributedCacheManager");
        for (String cacheName : manager.getCacheNames()) {
            manager.getCache(cacheName).clear();
        }
        LOG.debug("finished flushing cache");
    }

    private Iterator<HRImportRecord> getRecords(HRImport toImport) {
        if (toImport == null) {
            throw new IllegalArgumentException("HRImport toImport == null!");
        }
        if (toImport.getRecords() == null) {
            throw new IllegalStateException("toImport.getRecords() == null!");
        }
        return toImport.getRecords().iterator();
    }

    private KcPerson getKcPerson(String principalId) {
        KcPerson kcPerson = new KcPerson();
        kcPerson.setIdentityService(this.identityService);
        kcPerson.setBusinessObjectService(this.getBusinessObjectService());
        kcPerson.setPersonId(principalId);
        kcPerson.refresh();
        return kcPerson;
    }

    private KcPersonExtendedAttributes getKcPersonExtendedAttributes(KcPerson person) {
        KcPersonExtendedAttributes attribs = person.getExtendedAttributes();
        if (attribs == null) {
            attribs = new KcPersonExtendedAttributes();
            attribs.setPersonId(person.getPersonId());
        }
        return attribs;
    }

    private void logErrorForRecord(int recordIndex, Exception e) {
        StringWriter strWriter = new StringWriter();
        PrintWriter errorWriter = new PrintWriter(strWriter);
        errorWriter.append("import failed for record ").append(Integer.toString(recordIndex)).append(": ").append(e.getMessage()).append('\n');
        e.printStackTrace(errorWriter);
        errorWriter.flush();
        LOG.error(strWriter.toString());
    }

    protected Set<ConstraintViolation<HRImportRecord>> validateRecord(HRImportRecord record) {
        return this.validator.validate((Object)record, new Class[0]);
    }

    protected void handleRecord(HRImportRecord record) {
        Set<ConstraintViolation<HRImportRecord>> violations = this.validateRecord(record);
        if (violations != null && !violations.isEmpty()) {
            throw new IllegalArgumentException(violations.toString());
        }
        String principalId = record.getPrincipalId();
        EntityBo entity = EntityBo.from((Entity)this.identityService.getEntityByPrincipalId(principalId));
        if (entity != null) {
            LOG.debug("updating existing entity: " + principalId);
        } else {
            String suppliedEntityId = record.getEntityId();
            if (suppliedEntityId != null && this.legacyDataAdapter.findBySinglePrimaryKey(EntityBo.class, (Object)suppliedEntityId) != null) {
                LOG.error("entity ID collision: " + suppliedEntityId);
                throw new IllegalArgumentException("A person already exists with entity ID: " + suppliedEntityId);
            }
            LOG.debug("creating new entity: " + principalId);
            entity = this.newEntityBo(record);
        }
        PrincipalBo principal = this.updateEntityBo(entity, record);
        if (record.getKcExtendedAttributes() != null) {
            this.updateExtendedAttributes(principal.getPrincipalId(), record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startImport(String importId, HRImport toImport) {
        LOG.debug("starting import " + importId);
        this.flushCache();
        try {
            HashMap<String, Integer> principalToRecordNumber = new HashMap<String, Integer>();
            HRImportServiceImpl.addRunningImport(importId);
            Iterator<HRImportRecord> records = this.getRecords(toImport);
            int numRecords = toImport.getRecordCount();
            HashSet<String> processedPrincipals = new HashSet<String>(numRecords);
            int i = 0;
            while (i < numRecords && records.hasNext()) {
                int recordNumber = i + 1;
                if (!HRImportServiceImpl.isRunning(importId)) {
                    LOG.debug("import aborted. stopping at record " + recordNumber);
                    break;
                }
                String principalId = null;
                try {
                    HRImportRecord record = records.next();
                    principalId = record.getPrincipalId();
                    principalToRecordNumber.put(principalId, recordNumber);
                    if (processedPrincipals.contains(principalId)) {
                        throw new IllegalArgumentException("Duplicate records for the same principalId not allowed in a single import");
                    }
                    this.handleRecord(record);
                    if (record.isActive()) {
                        this.statusService.recordProcessed(importId, principalId);
                        continue;
                    }
                    this.statusService.recordInactivated(importId, principalId);
                }
                catch (Exception e) {
                    this.statusService.recordError(importId, new ImportError(recordNumber, principalId, e.getClass().getSimpleName() + " " + e.getMessage()));
                    this.logErrorForRecord(recordNumber, e);
                }
                finally {
                    if (principalId != null) {
                        processedPrincipals.add(principalId);
                    }
                    i = recordNumber;
                }
            }
            if (records.hasNext()) {
                throw new IllegalArgumentException("recordCount " + numRecords + " is less than number of records");
            }
            if (i < numRecords) {
                throw new IllegalArgumentException("recordCount " + numRecords + " is more than number of records");
            }
            LOG.debug("finished processing records");
            if (HRImportServiceImpl.isRunning(importId)) {
                LOG.debug("deactivating people who were missing from import");
                this.deactivatePeople(this.statusService.getActivePrincipalNamesMissingFromImport(importId));
                LOG.debug("finished deactivating people");
            }
            this.flushCache();
            String authToken = AuthServiceUserLoginFilter.getAuthToken(GlobalVariables.getUserSession());
            if (authToken != null && !authToken.trim().equals("")) {
                CoreUsersPushStatus pushStatus = this.authServicePushService.pushAllUsers();
                pushStatus.getErrors().forEach((key, value) -> this.statusService.recordError(importId, new ImportError((Integer)principalToRecordNumber.get(key), (String)key, (String)value)));
            }
        }
        finally {
            HRImportServiceImpl.stopRunningImport(importId);
        }
        LOG.debug("HRImportServiceImpl.startImport(...) finished");
    }

    protected final <T, Z> List<T> adaptAndSortList(String entityId, List<Z> toImport, PersistableBoMergeAdapter<T, Z> adapter) {
        ArrayList<T> adaptedList = new ArrayList<T>();
        boolean defaultSet = false;
        int index = 0;
        for (Z name : toImport) {
            int insertAt;
            T newBo = adapter.setFields(++index, adapter.newBO(entityId), name);
            if (adapter.isBoDefaultable() && ((Defaultable)newBo).isDefaultValue()) {
                if (defaultSet) {
                    throw new IllegalArgumentException("Multiple records of type " + newBo.getClass().getSimpleName() + " set as default value");
                }
                defaultSet = true;
            }
            if ((insertAt = Collections.binarySearch(adaptedList, newBo, adapter)) >= 0) {
                throw new IllegalArgumentException("Duplicate records of type " + newBo.getClass().getSimpleName() + " encountered");
            }
            adaptedList.add(-(insertAt + 1), newBo);
        }
        return adaptedList;
    }

    protected <T, Z> boolean mergeImportedBOs(List<Z> objsToMerge, List<T> existingBOs, PersistableBoMergeAdapter<T, Z> adapter, String entityId) {
        ArrayList<T> currBOs;
        ArrayList<Object> arrayList = currBOs = existingBOs != null ? new ArrayList<T>(existingBOs) : new ArrayList();
        if (objsToMerge != null) {
            List<T> importBOs = this.adaptAndSortList(entityId, objsToMerge, adapter);
            currBOs.sort(adapter);
            boolean collectionModified = false;
            LinkedList<T> oldToDelete = new LinkedList<T>();
            LinkedList<T> newToAdd = new LinkedList<T>();
            int lowerBound = 0;
            for (T importBO : importBOs) {
                boolean importHandled = false;
                for (int i = lowerBound; i < currBOs.size() && !importHandled; ++i) {
                    T oldBO = currBOs.get(i);
                    int comp = adapter.compare(importBO, oldBO);
                    if (comp < 0) {
                        newToAdd.add(importBO);
                        importHandled = true;
                        continue;
                    }
                    if (comp == 0) {
                        importHandled = true;
                        ++lowerBound;
                        continue;
                    }
                    oldToDelete.add(oldBO);
                    ++lowerBound;
                }
                if (importHandled) continue;
                newToAdd.add(importBO);
            }
            for (int i = lowerBound; i < currBOs.size(); ++i) {
                oldToDelete.add(currBOs.get(i));
            }
            for (Object oldBO : oldToDelete) {
                adapter.delete(this.legacyDataAdapter, oldBO);
                collectionModified = true;
            }
            int index = 0;
            for (Object newBO : newToAdd) {
                adapter.save(++index, this.legacyDataAdapter, newBO);
                collectionModified = true;
            }
            return collectionModified;
        }
        return false;
    }

    protected PrincipalBo updateEntityBo(EntityBo entity, HRImportRecord record) {
        EmailCollection emailColl;
        PhoneCollection phoneColl;
        AffiliationCollection affColl;
        PrincipalBo principal = this.updatePrincipal(entity, record);
        NameCollection nameColl = record.getNameCollection();
        if (nameColl != null) {
            this.mergeImportedBOs(nameColl.getNames(), entity.getNames(), this.nameAdapter, entity.getId());
        }
        if ((affColl = record.getAffiliationCollection()) != null) {
            this.mergeAffiliations(entity, affColl);
        }
        EntityTypeContactInfoBo contactInfo = this.getEntityTypeContactInfoBo(entity);
        AddressCollection addrColl = record.getAddressCollection();
        if (addrColl != null) {
            this.mergeImportedBOs(addrColl.getAddresses(), contactInfo.getAddresses(), this.addressAdapter, entity.getId());
        }
        if ((phoneColl = record.getPhoneCollection()) != null) {
            this.mergeImportedBOs(phoneColl.getPhones(), contactInfo.getPhoneNumbers(), this.phoneAdapter, entity.getId());
        }
        if ((emailColl = record.getEmailCollection()) != null) {
            this.mergeImportedBOs(emailColl.getEmails(), contactInfo.getEmailAddresses(), this.emailAdapter, entity.getId());
        }
        return principal;
    }

    private void mergeAffiliations(EntityBo entity, AffiliationCollection affColl) {
        HashMap<String, EntityAffiliationBo> matchedAffiliations = new HashMap<String, EntityAffiliationBo>();
        for (Affiliation affil : affColl.getAffiliations()) {
            List<Employment> employments = affil.getEmployments();
            EntityAffiliationBo newAffil = this.affiliationAdapter.setFields(this.affiliationAdapter.newBO(entity.getId()), affil);
            boolean exists = false;
            for (EntityAffiliationBo dbAffil : entity.getAffiliations()) {
                if (this.affiliationAdapter.compare(newAffil, dbAffil) != 0) continue;
                dbAffil.setActive(newAffil.isActive());
                dbAffil.setDefaultValue(newAffil.getDefaultValue());
                this.legacyDataAdapter.save((Object)dbAffil);
                this.mergeAffiliationEmployment(entity.getId(), employments, dbAffil, entity.getEmploymentInformation());
                matchedAffiliations.put(dbAffil.getId(), dbAffil);
                exists = true;
                break;
            }
            if (exists) continue;
            entity.getAffiliations().add(newAffil);
            newAffil = (EntityAffiliationBo)this.legacyDataAdapter.save((Object)newAffil);
            matchedAffiliations.put(newAffil.getId(), newAffil);
            for (Employment employment : employments) {
                if (employment == null) continue;
                EntityEmploymentBo newEmployment = this.createNewEmploymentInfo(entity.getId(), employment, newAffil, entity.getEmploymentInformation());
                this.legacyDataAdapter.save((Object)newEmployment);
            }
        }
        Iterator iter = entity.getAffiliations().iterator();
        while (iter.hasNext()) {
            EntityAffiliationBo dbAffil = (EntityAffiliationBo)iter.next();
            if (matchedAffiliations.containsKey(dbAffil.getId())) continue;
            Iterator empIter = entity.getEmploymentInformation().iterator();
            while (empIter.hasNext()) {
                EntityEmploymentBo employment = (EntityEmploymentBo)empIter.next();
                if (!Objects.equals(employment.getEntityAffiliationId(), dbAffil.getId())) continue;
                empIter.remove();
                this.legacyDataAdapter.delete((Object)employment);
            }
            iter.remove();
            this.legacyDataAdapter.delete((Object)dbAffil);
        }
    }

    private void mergeAffiliationEmployment(String entityId, List<Employment> employments, EntityAffiliationBo dbAffil, List<EntityEmploymentBo> empBos) {
        employments.forEach(employment -> employment.setEntityAffiliationId(dbAffil.getId()));
        this.mergeImportedBOs(employments, empBos.stream().filter(empBo -> Objects.equals(empBo.getEntityAffiliationId(), dbAffil.getId())).collect(Collectors.toList()), this.employmentAdapter, entityId);
    }

    private EntityEmploymentBo createNewEmploymentInfo(String entityId, Employment employment, EntityAffiliationBo newAffil, List<EntityEmploymentBo> empBos) {
        EntityEmploymentBo newEmployment = this.employmentAdapter.setFields(this.getMaxEmploymentRecordId(empBos) + 1, this.employmentAdapter.newBO(entityId), employment);
        newEmployment.setActive(newAffil.isActive());
        newEmployment.setEntityAffiliationId(newAffil.getId());
        newEmployment.setEntityAffiliation(newAffil);
        return newEmployment;
    }

    private int getMaxEmploymentRecordId(List<EntityEmploymentBo> empBos) {
        return empBos.stream().map(EntityEmploymentBase::getEmploymentRecordId).mapToInt(Integer::parseInt).max().orElse(1);
    }

    @Override
    public void deletePerson(String entityId) {
        EntityBo entity = (EntityBo)this.legacyDataAdapter.findBySinglePrimaryKey(EntityBo.class, (Object)entityId);
        this.delete(entity);
    }

    protected void delete(EntityBo entity) {
        LOG.debug("Deleting Entity: " + entity);
        this.legacyDataAdapter.delete((Object)entity.getPrincipals());
        this.legacyDataAdapter.delete((Object)entity.getNames());
        this.legacyDataAdapter.delete((Object)entity.getEmploymentInformation());
        this.legacyDataAdapter.delete((Object)entity.getAffiliations());
        for (EntityTypeContactInfoBo contactInfo : entity.getEntityTypeContactInfos()) {
            this.legacyDataAdapter.delete((Object)contactInfo.getAddresses());
            this.legacyDataAdapter.delete((Object)contactInfo.getPhoneNumbers());
            this.legacyDataAdapter.delete((Object)contactInfo.getEmailAddresses());
        }
        this.legacyDataAdapter.delete((Object)entity.getEntityTypeContactInfos());
        KcPerson person = KcPerson.fromPersonId(entity.getId());
        KcPersonExtendedAttributes attributes = person.getExtendedAttributes();
        if (attributes.getPersonId() != null) {
            this.legacyDataAdapter.delete((Object)person.getExtendedAttributes());
        }
        this.legacyDataAdapter.delete((Object)entity);
    }

    protected PrincipalBo updatePrincipal(EntityBo entity, HRImportRecord record) {
        Principal existingPrincipal;
        String principalId = record.getPrincipalId();
        String principalName = record.getPrincipalName();
        PrincipalBo principal = (PrincipalBo)this.legacyDataAdapter.findBySinglePrimaryKey(PrincipalBo.class, (Object)principalId);
        boolean modified = false;
        if (principal != null) {
            if (!principalId.equals(principal.getPrincipalId())) {
                throw new IllegalStateException("selected for principal with ID " + principalId + " but retrieved a principal with ID " + principal.getPrincipalId());
            }
            if (entity.getId() != null && principal.getEntityId() != null && !entity.getId().equals(principal.getEntityId())) {
                throw new IllegalArgumentException("principal with ID " + principalId + " is already assigned to another person");
            }
            if (!principal.getPrincipalName().equals(record.getPrincipalName())) {
                principal.setPrincipalName(record.getPrincipalName());
                modified = true;
            }
            if (principal.isActive() != record.isActive()) {
                principal.setActive(record.isActive());
                modified = true;
            }
        } else {
            modified = true;
            principal = new PrincipalBo();
            principal.setPrincipalName(principalName);
            principal.setActive(true);
            principal.setPrincipalId(principalId);
            principal.setEntityId(entity.getId());
        }
        if ((existingPrincipal = this.identityService.getPrincipalByPrincipalName(principalName)) != null && !existingPrincipal.getPrincipalId().equals(principalId)) {
            throw new IllegalArgumentException("Cannot set principal_name for principal_id '" + principalId + "' to '" + principalName + "' because it is already in use by principal_id: '" + existingPrincipal.getPrincipalId() + "'.");
        }
        if (modified) {
            return (PrincipalBo)this.legacyDataAdapter.save((Object)principal);
        }
        return principal;
    }

    private EntityTypeContactInfoBo getEntityTypeContactInfoBo(EntityBo entity) {
        EntityTypeContactInfoBo contactInfo = entity.getEntityTypeContactInfoByTypeCode(PERSON);
        if (contactInfo == null) {
            contactInfo = new EntityTypeContactInfoBo();
            contactInfo.setEntityId(entity.getId());
            contactInfo.setAddresses(new LinkedList());
            contactInfo.setPhoneNumbers(new LinkedList());
            contactInfo.setEmailAddresses(new LinkedList());
            contactInfo.setEntityTypeCode(PERSON);
            contactInfo.setActive(true);
            return (EntityTypeContactInfoBo)this.legacyDataAdapter.save((Object)contactInfo);
        }
        return contactInfo;
    }

    protected EntityBo newEntityBo(HRImportRecord record) {
        EntityBo entity = new EntityBo();
        String entityId = record.getEntityId();
        if (entityId != null) {
            entity.setId(entityId);
        }
        entity.setActive(record.isActive());
        return (EntityBo)this.legacyDataAdapter.save((Object)entity);
    }

    protected final boolean nullSafeEquals(Object obj0, Object obj1) {
        if (obj0 == null) {
            return obj1 == null;
        }
        return obj0.equals(obj1);
    }

    protected final boolean equals(KcPersonExtendedAttributes oldAttrs, KCExtendedAttributes newAttrs) {
        if (!this.nullSafeEquals(oldAttrs.getAgeByFiscalYear(), newAttrs.getAgeByFiscalYear())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getCitizenshipTypeCode(), newAttrs.getCitizenshipType())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getCounty(), newAttrs.getCounty())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getDegree(), newAttrs.getDegree())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getDirectoryDepartment(), newAttrs.getDirectoryDepartment())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getDirectoryTitle(), newAttrs.getDirectoryTitle())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getEducationLevel(), newAttrs.getEducationLevel())) {
            return false;
        }
        if (oldAttrs.getHandicappedFlag().booleanValue() != newAttrs.isHandicapped()) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getHandicapType(), newAttrs.getHandicapType())) {
            return false;
        }
        if (oldAttrs.getHasVisa().booleanValue() != newAttrs.isVisa()) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getIdProvided(), newAttrs.getIdProvided())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getIdVerified(), newAttrs.getIdVerified())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getMajor(), newAttrs.getMajor())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getMultiCampusPrincipalId(), newAttrs.getMultiCampusPrincipalId())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getMultiCampusPrincipalName(), newAttrs.getMultiCampusPrincipalName())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getOfficeLocation(), newAttrs.getOfficeLocation())) {
            return false;
        }
        if (oldAttrs.getOnSabbaticalFlag().booleanValue() != newAttrs.isOnSabbatical()) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getPrimaryTitle(), newAttrs.getPrimaryTitle())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getRace(), newAttrs.getRace())) {
            return false;
        }
        Date oldSalDate = oldAttrs.getSalaryAnniversaryDate();
        java.util.Date newSalDate = newAttrs.getSalaryAnniversaryDate();
        if (oldSalDate != null ? newSalDate == null || oldSalDate.getTime() != newSalDate.getTime() : newSalDate != null) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getSchool(), newAttrs.getSchool())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getSecondaryOfficeLocation(), newAttrs.getSecondaryOfficeLocation())) {
            return false;
        }
        if (oldAttrs.getVacationAccrualFlag().booleanValue() != newAttrs.isVacationAccrual()) {
            return false;
        }
        if (oldAttrs.getVeteranFlag().booleanValue() != newAttrs.isVeteran()) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getVeteranType(), newAttrs.getVeteranType())) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getVisaCode(), newAttrs.getVisaCode())) {
            return false;
        }
        Date oldVisaDate = oldAttrs.getVisaRenewalDate();
        java.util.Date newVisaDate = newAttrs.getVisaRenewalDate();
        if (oldVisaDate != null ? newVisaDate == null || oldVisaDate.getTime() != newVisaDate.getTime() : newVisaDate != null) {
            return false;
        }
        if (!this.nullSafeEquals(oldAttrs.getVisaType(), newAttrs.getVisaType())) {
            return false;
        }
        String oldGradYear = oldAttrs.getYearGraduated();
        Integer newGradYearInt = newAttrs.getYearGraduated();
        String newGradYear = newGradYearInt != null ? newGradYearInt.toString() : null;
        return this.nullSafeEquals(oldGradYear, newGradYear);
    }

    protected void updateExtendedAttributes(String principalId, HRImportRecord record) {
        DegreeCollection degColl;
        AppointmentCollection apptColl;
        KcPerson kcPerson = this.getKcPerson(principalId);
        KCExtendedAttributes newAttrs = record.getKcExtendedAttributes();
        KcPersonExtendedAttributes attrs = this.getKcPersonExtendedAttributes(kcPerson);
        attrs.setPersonId(principalId);
        if (!this.equals(attrs, newAttrs)) {
            attrs.setAgeByFiscalYear(newAttrs.getAgeByFiscalYear());
            attrs.setCitizenshipTypeCode(newAttrs.getCitizenshipType());
            attrs.setCitizenshipType((CitizenshipType)this.legacyDataAdapter.findBySinglePrimaryKey(CitizenshipType.class, (Object)newAttrs.getCitizenshipType()));
            attrs.setCounty(newAttrs.getCounty());
            attrs.setDegree(newAttrs.getDegree());
            attrs.setDirectoryDepartment(newAttrs.getDirectoryDepartment());
            attrs.setDirectoryTitle(newAttrs.getDirectoryTitle());
            attrs.setEducationLevel(newAttrs.getEducationLevel());
            attrs.setHandicappedFlag(newAttrs.isHandicapped());
            attrs.setHandicapType(newAttrs.getHandicapType());
            attrs.setHasVisa(newAttrs.isVisa());
            attrs.setIdProvided(newAttrs.getIdProvided());
            attrs.setIdVerified(newAttrs.getIdVerified());
            attrs.setMajor(newAttrs.getMajor());
            attrs.setMultiCampusPrincipalId(newAttrs.getMultiCampusPrincipalId());
            attrs.setMultiCampusPrincipalName(newAttrs.getMultiCampusPrincipalName());
            attrs.setOfficeLocation(newAttrs.getOfficeLocation());
            attrs.setOnSabbaticalFlag(newAttrs.isOnSabbatical());
            attrs.setPrimaryTitle(newAttrs.getPrimaryTitle());
            attrs.setRace(newAttrs.getRace());
            java.util.Date annvDate = newAttrs.getSalaryAnniversaryDate();
            if (annvDate != null) {
                attrs.setSalaryAnniversaryDate(new Date(annvDate.getTime()));
            }
            attrs.setSchool(newAttrs.getSchool());
            attrs.setSecondaryOfficeLocation(newAttrs.getSecondaryOfficeLocation());
            attrs.setVacationAccrualFlag(newAttrs.isVacationAccrual());
            attrs.setVeteranFlag(newAttrs.isVeteran());
            attrs.setVeteranType(newAttrs.getVeteranType());
            attrs.setVisaCode(newAttrs.getVisaCode());
            java.util.Date visaRenewDate = newAttrs.getVisaRenewalDate();
            if (visaRenewDate != null) {
                attrs.setVisaRenewalDate(new Date(visaRenewDate.getTime()));
            }
            attrs.setVisaType(newAttrs.getVisaType());
            Integer gradYear = newAttrs.getYearGraduated();
            if (gradYear != null) {
                attrs.setYearGraduated(gradYear.toString());
            }
            attrs = (KcPersonExtendedAttributes)this.legacyDataAdapter.save((Object)attrs);
        }
        if ((apptColl = record.getAppointmentCollection()) == null || this.mergeImportedBOs(apptColl.getAppointments(), attrs.getPersonAppointments(), this.appointmentAdapter, principalId)) {
            // empty if block
        }
        if ((degColl = record.getDegreeCollection()) == null || this.mergeImportedBOs(degColl.getDegrees(), attrs.getPersonDegrees(), this.degreeAdapter, principalId)) {
            // empty if block
        }
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public void setCacheManagerRegistry(CacheManagerRegistry registry) {
        this.cacheManagerRegistry = registry;
    }

    @Override
    public void abort(String importId) {
        HRImportServiceImpl.stopRunningImport(importId);
    }

    public AuthServicePushService getAuthServicePushService() {
        return this.authServicePushService;
    }

    public void setAuthServicePushService(AuthServicePushService authServicePushService) {
        this.authServicePushService = authServicePushService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public CacheManagerRegistry getCacheManagerRegistry() {
        return this.cacheManagerRegistry;
    }

    public ImportStatusService getStatusService() {
        return this.statusService;
    }

    public void setStatusService(ImportStatusService statusService) {
        this.statusService = statusService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public EntityAddressBoAdapter getAddressAdapter() {
        return this.addressAdapter;
    }

    public void setAddressAdapter(EntityAddressBoAdapter addressAdapter) {
        this.addressAdapter = addressAdapter;
    }

    public EntityAffiliationBoAdapter getAffiliationAdapter() {
        return this.affiliationAdapter;
    }

    public void setAffiliationAdapter(EntityAffiliationBoAdapter affiliationAdapter) {
        this.affiliationAdapter = affiliationAdapter;
    }

    public EntityEmailBoAdapter getEmailAdapter() {
        return this.emailAdapter;
    }

    public void setEmailAdapter(EntityEmailBoAdapter emailAdapter) {
        this.emailAdapter = emailAdapter;
    }

    public EntityEmploymentBoAdapter getEmploymentAdapter() {
        return this.employmentAdapter;
    }

    public void setEmploymentAdapter(EntityEmploymentBoAdapter employmentAdapter) {
        this.employmentAdapter = employmentAdapter;
    }

    public EntityNameBoAdapter getNameAdapter() {
        return this.nameAdapter;
    }

    public void setNameAdapter(EntityNameBoAdapter nameAdapter) {
        this.nameAdapter = nameAdapter;
    }

    public EntityPhoneBoAdapter getPhoneAdapter() {
        return this.phoneAdapter;
    }

    public void setPhoneAdapter(EntityPhoneBoAdapter phoneAdapter) {
        this.phoneAdapter = phoneAdapter;
    }

    public PersonAppointmentBoAdapter getAppointmentAdapter() {
        return this.appointmentAdapter;
    }

    public void setAppointmentAdapter(PersonAppointmentBoAdapter appointmentAdapter) {
        this.appointmentAdapter = appointmentAdapter;
    }

    public PersonDegreeBoAdapter getDegreeAdapter() {
        return this.degreeAdapter;
    }

    public void setDegreeAdapter(PersonDegreeBoAdapter degreeAdapter) {
        this.degreeAdapter = degreeAdapter;
    }
}

