--
-- Copyright © 2005-2019 Kuali, Inc.
-- All Rights Reserved
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
--

delete from notification_mdl_role_qlfr where NOTIFICATION_MODULE_ROLE_ID in (select NOTIFICATION_MODULE_ROLE_ID from notification_module_role where MODULE_CODE in (7, 9, 11));
delete from notification_module_role where MODULE_CODE in (7, 9, 11);

delete from notification where NOTIFICATION_TYPE_ID in (select NOTIFICATION_TYPE_ID from notification_type where MODULE_CODE in (7, 9, 11));
delete from notification_type_recipient where NOTIFICATION_TYPE_ID in (select NOTIFICATION_TYPE_ID from notification_type where MODULE_CODE in (7, 9, 11));
delete from notification_type where MODULE_CODE in (7, 9, 11);

-- NOT deleting IRB and IACUC related questionnaire data for reasons of system stability

-- watermark
drop table WATERMARK;
drop table SEQ_WATERMARK_ID;

-- person mass change
drop table PMC_IACUC_PROTOCOL;
drop table PMC_PROTOCOL;
drop table SEQ_PERSON_MASS_CHANGE_ID;

-- views
drop view IACUC_PROTOCOL_SUBMISSION_V;
drop view PROTOCOL_SUBMISSION_V;


-- clear out attachments

-- no fk to drop
delete from file_data where id in (select file_data_id from attachment_file t inner join IACUC_PROTOCOL_ATTACH_PROTOCOL u on t.file_id = u.file_id);
delete from attachment_file where file_id in (select file_id from IACUC_PROTOCOL_ATTACH_PROTOCOL);

-- no fk to drop
delete from file_data where id in (select file_data_id from attachment_file t inner join IACUC_PROTOCOL_ATTACH_PRSNNL u on t.file_id = u.file_id);
delete from attachment_file where file_id in (select file_id from IACUC_PROTOCOL_ATTACH_PRSNNL);

-- no fk to drop
delete from file_data where id in (select file_data_id from attachment_file t inner join PROTOCOL_ATTACHMENT_PROTOCOL u on t.file_id = u.file_id);
delete from attachment_file where file_id in (select file_id from PROTOCOL_ATTACHMENT_PROTOCOL);

-- no fk to drop
delete from file_data where id in (select file_data_id from attachment_file t inner join PROTOCOL_ATTACHMENT_PERSONNEL u on t.file_id = u.file_id);
delete from attachment_file where file_id in (select file_id from PROTOCOL_ATTACHMENT_PERSONNEL);


-- irb, iacuc, committee, meeting, etc

drop table COMM_MEMBER_EXPERTISE;
drop table COMM_RESEARCH_AREAS;
drop table COMM_SCHEDULE_MINUTES;
drop table COMM_SCHEDULE_ACT_ITEMS;
drop table COMM_SCHEDULE_MINUTE_DOC;
drop table SCHEDULE_AGENDA;
drop table PROTOCOL_VOTE_ABSTAINEES;
drop table PROTOCOL_VOTE_RECUSED;
drop table COMM_SCHEDULE_ATTENDANCE;
drop table COMM_BATCH_CORRESP_DETAIL;
drop table COMM_SCHEDULE_ATTACHMENTS;
drop table COMM_MEMBER_ROLES;
drop table ATTACHMENTS_TYPE;
drop table IACUC_PROTOCOL_STUDY_GROUP_HDR;
drop table IACUC_PROTOCOL_STUDY_GROUPS;
drop table IACUC_PROTO_STUDY_GROUP_LOCS;
drop table IACUC_PROTO_STUDY_CUSTOM_DATA;
drop table IACUC_PROC_CAT_CUSTOM_DATA;
drop table IACUC_PERSON_TRAINING;
drop table IACUC_LOCATION_NAME;
drop table IACUC_LOCATION_TYPE;
drop table IACUC_PROC_PERSON_RESPONSIBLE;
drop table IACUC_PAIN_CATEGORY;
drop table IACUC_SPECIES_COUNT_TYPE;
drop table IACUC_PROTOCOL_DOCUMENT;
drop table IACUC_PROTO_AMEND_RENEW_MOD;
drop table IACUC_PROTOCOL_RESEARCH_AREAS;
drop table IACUC_PROTOCOL_SPECIAL_REVIEW;
drop table IACUC_EXEMPT_NUMBER;
drop table IACUC_PROTO_REVIEW_TYPE_DETER;
drop table IACUC_PROTOCOL_REVIEWER_TYPE;
drop table IACUC_SUBMISSION_STATUS;
drop table IACUC_PROTOCOL_UNITS;
drop table IACUC_PROTOCOL_ATTACHMENT_TYPE;
drop table IACUC_ALT_SEARCH_DB;
drop table IACUC_PRINCIPLES;
drop table IACUC_PROTOCOL_ALT_SEARCH;
drop table IACUC_PROTOCOL_ALT_SEARCH_DBS;
drop table IACUC_PROTOCOL_SPECIES;
drop table IACUC_PROTOCOL_CUSTOM_DATA;
drop table IACUC_PROTOCOL_REFERENCE_TYPE;
drop table IACUC_PROTOCOL_REFERENCES;
drop table IACUC_PROTOCOL_ORG_TYPE;
drop table IACUC_PROTOCOL_LOCATION;
drop table IACUC_PROTOCOL_FUNDING_SOURCE;
drop table IACUC_PROTOCOL_EXCEPTIONS;
drop table IACUC_PROTOCOL_PRSN_ROLE_MPPNG;
drop table IACUC_PROTO_ATTACH_TYPE_GROUP;
drop table IACUC_PROTOCOL_ONLN_RVWS;
drop table IACUC_REVIEWER_ATTACHMENTS;
drop table IACUC_PROTOCOL_ATTACH_PROTOCOL;
drop table IACUC_PROTOCOL_NOTEPAD;
drop table IACUC_PROTOCOL_ATTACH_PRSNNL;
drop table IACUC_PROTO_CORRESP_TEMPL;
drop table IACUC_VALID_PROTO_SUB_TYP_QL;
drop table IACUC_PROTOCOL_SUBMISSION_DOC;
drop table IACUC_BATCH_CORRESP_DETAIL;
drop table IACUC_ORG_CORRESPONDENT;
drop table IACUC_UNIT_CORRESPONDENT;
drop table IACUC_PROTOCOL_NOTIFICATION;
drop table IACUC_CORRESPONDENT_TYPE;
drop table IACUC_PROTOCOL_CONTINGENCY;
drop table PROTOCOL_UNITS;
drop table PROTOCOL_RESEARCH_AREAS;
drop table PROTOCOL_RISK_LEVELS;
drop table PROTOCOL_VULNERABLE_SUB;
drop table PROTOCOL_REFERENCES;
drop table PROTOCOL_LOCATION;
drop table PROTOCOL_FUNDING_SOURCE;
drop table PROTOCOL_PERSON_ROLE_MAPPING;
drop table PROTOCOL_EXEMPT_NUMBER;
drop table PROTOCOL_ATTACHMENT_TYPE_GROUP;
drop table PROTOCOL_ATTACHMENT_PROTOCOL;
drop table PROTOCOL_ATTACHMENT_PERSONNEL;
drop table PROTOCOL_NOTEPAD;
drop table PROTOCOL_EXEMPT_CHKLST;
drop table PROTOCOL_EXPIDITED_CHKLST;
drop table PROTOCOL_ONLN_RVWS;
drop table PROTO_CORRESP_TEMPL;
drop table PROTOCOL_NOTIFICATION;
drop table REVIEWER_ATTACHMENTS;
drop table CORRESPONDENT_TYPE;
drop table ORGANIZATION_CORRESPONDENT;
drop table UNIT_CORRESPONDENT;
drop table BATCH_CORRESPONDENCE_DETAIL;
drop table VALID_PROTO_SUB_REV_TYPE;
drop table VALID_PROTO_SUB_TYPE_QUAL;
drop table VALID_PROTO_ACTION_CORESP;
drop table VALID_PROTO_ACTION_ACTION;
drop table VALID_IACUC_PROTO_SUB_REV_TYPE;
drop table VALID_IACUC_PROTO_ACTN_ACTN;
drop table VALID_IACUC_PROTO_ACT_CORESP;
drop table PROTO_AMEND_RENEW_MODULES;
drop table PROTOCOL_SUBMISSION_DOC;
drop table PROTO_NOTIFICATION_TEMPL;
drop table EXEMPT_STUDIES_CHECKLIST;
drop table COMMITTEE_DOCUMENT;
drop table PROTOCOL_CONTINGENCY;
drop table COMM_BATCH_CORRESP;
drop table MEMBERSHIP_ROLE;
drop table MINUTE_ENTRY_TYPE;
drop table SCHEDULE_ACT_ITEM_TYPE;
drop table IACUC_PROTO_AMEND_RENEWAL;
drop table IACUC_PROTOCOL_ACTIONS;
drop table IACUC_SUBMISSION_TYPE_QUALIF;
drop table IACUC_EXCEPTION_CATEGORY;
drop table IACUC_PROTO_ATTACHMENT_STATUS;
drop table IACUC_PROTO_ATTACHMENT_GROUP;
drop table IACUC_PROTOCOL_OLR_DOCUMENT;
drop table IACUC_PROTO_OLR_DT_REC_TYPE;
drop table IACUC_PROTOCOL_OLR_STATUS;
drop table IACUC_PROTOCOL_MODULES;
drop table IACUC_PROTO_CORRESPONDENCE;
drop table IACUC_BATCH_CORRESPONDENCE;
drop table PROTOCOL_ORG_TYPE;
drop table PROTOCOL_PERSONS;
drop table PROTOCOL_SPECIAL_REVIEW;
drop table PROTOCOL_ATTACHMENT_STATUS;
drop table PROTOCOL_ATTACHMENT_GROUP;
drop table PROTOCOL_CORRESPONDENCE;
drop table PROTOCOL_ONLN_RVW_DOCUMENT;
drop table PROTOCOL_ONLN_RVW_STATUS;
drop table PROTOCOL_ONLN_RVW_DETERM_RECOM;
drop table PROTO_AMEND_RENEWAL;
drop table PROTOCOL_MODULES;
drop table EXPEDITED_REVIEW_CHECKLIST;
drop table BATCH_CORRESPONDENCE;
drop table AFFILIATION_TYPE;
drop table VULNERABLE_SUBJECT_TYPE;
drop table COMM_MEMBERSHIPS;
drop table COMM_MEMBERSHIP_TYPE;
drop table COMM_DECISION_MOTION_TYPE;
drop table IACUC_PROCEDURES;
drop table IACUC_PROCEDURE_CATEGORY;
drop table IACUC_SPECIES;
drop table IACUC_SUBMISSION_TYPE;
drop table IACUC_PROTO_REVIEW_TYPE;
drop table IACUC_PROTOCOL_ACTION_TYPE;
drop table IACUC_PROTOCOL_SUBMISSION;
drop table IACUC_PROTOCOL_PERSONS;
drop table IACUC_PROTOCOL_PERSON_ROLES;
drop table IACUC_PROTOCOL_REVIEWERS;
drop table IACUC_PROTOCOL_CORRESP_TYPE;
drop table IACUC_RESEARCH_AREAS;
drop table PROTOCOL_REFERENCE_TYPE;
drop table PROTOCOL_PERSON_ROLES;
drop table PROTOCOL_ATTACHMENT_TYPE;
drop table PROTO_CORRESP_TYPE;
drop table PROTOCOL_ACTIONS;
drop table PROTOCOL_REVIEWERS;
drop table PROTOCOL_SUBMISSION;
drop table PROTOCOL_REVIEWER_TYPE;
drop table PROTOCOL_ACTION_TYPE;
drop table SUBMISSION_TYPE;
drop table SUBMISSION_STATUS;
drop table SUBMISSION_TYPE_QUALIFIER;
drop table FUNDING_SOURCE_TYPE;
drop table RESEARCH_AREAS;
drop table IACUC_AFFILIATION_TYPE;
drop table COMMITTEE;
drop table COMM_SCHEDULE;
drop table SCHEDULE_STATUS;
drop table COMMITTEE_TYPE;
drop table PROTOCOL_REVIEW_TYPE;
drop table IACUC_PROTOCOL;
drop table IACUC_PROTOCOL_STATUS;
drop table IACUC_PROTOCOL_TYPE;
drop table IACUC_PROTOCOL_PROJECT_TYPE;
drop table PROTOCOL;
drop table PROTOCOL_DOCUMENT;
drop table PROTOCOL_STATUS;
drop table PROTOCOL_TYPE;


drop table SEQ_COMMITTEE_ID;
drop table SEQ_MEETING_ID;
drop table SEQ_COMM_SCHED_ATTACH_ID;
drop table SEQ_IACUC_PROT_STUD_GRP_HDR_ID;
drop table SEQ_IACUC_PROTO_STUDY_GROUP_ID;
drop table SEQ_IACUC_PROT_STUD_GRP_LOC_ID;
drop table SEQ_IACUC_PROT_STUD_CUS_DAT_ID;
drop table SEQ_IACUC_PROC_CAT_CUST_DAT_ID;
drop table SEQ_IACUC_PERSON_TRAINING_ID;
drop table SEQ_IACUC_PROC_PERS_RESP_ID;
drop table SEQ_IACUC_PROTOCOL_ID;
drop table SEQ_IACUC_PROT_AMND_REN_ID;
drop table SEQ_IACUC_PROT_AMND_REN_MOD_ID;
drop table SEQ_IACUC_PROTOCOL_ACTIONS_ID;
drop table SEQ_IACUC_PROTOCOL_RES_AREA_ID;
drop table SEQ_IACUC_SPECIAL_REVIEW_ID;
drop table SEQ_IACUC_EXEMPT_NUMBER_ID;
drop table SEQ_IACUC_PROTO_SUBMISSION_ID;
drop table SEQ_IACUC_PRINCIPLES_ID;
drop table SEQ_IACUC_PRTCL_ALT_SRCH_ID;
drop table SEQ_IAC_PRTCL_ALT_SRCH_DBS_ID;
drop table SEQ_IACUC_PROTOCOL_SPECIES_ID;
drop table SEQ_IACUC_PROT_CUST_DATA_ID;
drop table SEQ_IACUC_PROTOCOL_REFS_ID;
drop table SEQ_IACUC_PROTOCOL_LOCS_ID;
drop table SEQ_IACUC_PROTOCOL_FUND_SRC_ID;
drop table SEQ_IACUC_PROTO_EXCEPTION_ID;
-- may not exist
drop table if exists SEQ_IAC_PRTCL_PERSON_ROLE_ID;
drop table SEQ_IAC_PRTCL_PRSNRL_MPPNG_ID;
drop table SEQ_PROTO_ATTCHTYPEGRP_ID;
drop table SEQ_IACUC_PROTOCOL_OLR_ID;
drop table SEQ_IACUC_PROTOCOL_REVIEWER_ID;
drop table SEQ_IACUC_REVIEWER_ATTACH_ID;
drop table SEQ_IACUC_PA_PROTOCOL_ID;
drop table SEQ_IACUC_PROTOCOL_NOTEPAD_ID;
drop table SEQ_IACUC_PA_PERSONNEL_ID;
drop table SEQ_IACUC_PROTO_CORRESP_TEMPL;
-- may not exist
drop table if exists SEQ_VAL_IAC_PRO_SUB_REV_TYP_ID;
drop table SEQ_VALID_PRO_SUB_TYPE_QUAL_ID;
drop table SEQ_IACUC_PROTO_CORR_ID;
drop table SEQ_IACUC_PROTO_SUBMIS_DOC_ID;
drop table SEQ_UNIT_CORRESP_ID;
drop table SEQ_VAL_IACUC_PROT_ACT_COR_ID;
drop table SEQ_PROTOCOL_ID;
drop table SEQ_VAL_PROTO_SUB_REV_TYP_ID;
drop table SEQ_VAL_PROTO_SUB_TYP_QUAL_ID;
drop table SEQ_ORG_CORRESP_ID;