/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.SchemaAnalyzer;
import net.sourceforge.schemaspy.model.ConnectionFailure;
import net.sourceforge.schemaspy.model.EmptySchemaException;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.ProcessExecutionException;
import net.sourceforge.schemaspy.ui.MainFrame;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 1 && stringArray[0].equals("-gui")) {
            new MainFrame().setVisible(true);
            return;
        }
        SchemaAnalyzer schemaAnalyzer = new SchemaAnalyzer();
        int n = 1;
        try {
            n = schemaAnalyzer.analyze(new Config(stringArray)) == null ? 1 : 0;
        }
        catch (ConnectionFailure connectionFailure) {
            n = 3;
        }
        catch (EmptySchemaException emptySchemaException) {
            n = 2;
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            System.err.println();
            if (invalidConfigurationException.getParamName() != null) {
                System.err.println("Bad parameter specified for " + invalidConfigurationException.getParamName());
            }
            System.err.println(invalidConfigurationException.getMessage());
            if (invalidConfigurationException.getCause() != null && !invalidConfigurationException.getMessage().endsWith(invalidConfigurationException.getMessage())) {
                System.err.println(" caused by " + invalidConfigurationException.getCause().getMessage());
            }
            Logger logger = Logger.getLogger(Main.class.getName());
            logger.log(Level.FINE, "Command line parameters: " + Arrays.asList(stringArray));
            logger.log(Level.FINE, "Invalid configuration detected", invalidConfigurationException);
        }
        catch (ProcessExecutionException processExecutionException) {
            System.err.println(processExecutionException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(n);
    }
}

