/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ClassUtils;

public class SimpleMessageConverter
implements MessageConverter {
    @Override
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        Object payload = message.getPayload();
        if (targetClass == null) {
            return payload;
        }
        return ClassUtils.isAssignableValue(targetClass, payload) ? payload : null;
    }

    @Override
    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        MessageHeaderAccessor accessor;
        if (payload == null) {
            return null;
        }
        if (headers != null && (accessor = MessageHeaderAccessor.getAccessor(headers, MessageHeaderAccessor.class)) != null && accessor.isMutable()) {
            return MessageBuilder.createMessage(payload, accessor.getMessageHeaders());
        }
        return MessageBuilder.withPayload(payload).copyHeaders(headers).build();
    }
}

