/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.kit;

import java.io.Serializable;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.copy.CloneableObjectCopyStrategy;
import org.apache.ojb.otm.copy.MetadataObjectCopyStrategy;
import org.apache.ojb.otm.copy.NoOpObjectCopyStrategy;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.copy.OjbCloneable;
import org.apache.ojb.otm.lock.map.InMemoryLockMap;
import org.apache.ojb.otm.lock.map.LockMap;
import org.apache.ojb.otm.lock.wait.LockWaitStrategy;
import org.apache.ojb.otm.lock.wait.TimeoutStrategy;
import org.apache.ojb.otm.swizzle.CopySwizzling;
import org.apache.ojb.otm.swizzle.Swizzling;
import org.apache.ojb.otm.transaction.LocalTransactionFactory;
import org.apache.ojb.otm.transaction.TransactionFactory;

public class SimpleKit
extends OTMKit {
    private static SimpleKit _instance;
    protected TransactionFactory _txFactory = new LocalTransactionFactory();
    protected Swizzling _swizzlingStrategy = new CopySwizzling();
    protected LockWaitStrategy _lockWaitStrategy = new TimeoutStrategy();
    protected LockMap _lockMap = new InMemoryLockMap();
    protected ObjectCopyStrategy _noOpCopyStrategy = new NoOpObjectCopyStrategy();
    protected ObjectCopyStrategy _defaultCopyStrategy = new MetadataObjectCopyStrategy();
    protected ObjectCopyStrategy _cloneableCopyStrategy = new CloneableObjectCopyStrategy();

    protected SimpleKit() {
    }

    public static SimpleKit getInstance() {
        if (_instance == null) {
            _instance = new SimpleKit();
        }
        return _instance;
    }

    @Override
    protected TransactionFactory getTransactionFactory() {
        return this._txFactory;
    }

    @Override
    public Swizzling getSwizzlingStrategy() {
        return this._swizzlingStrategy;
    }

    @Override
    public LockWaitStrategy getLockWaitStrategy() {
        return this._lockWaitStrategy;
    }

    @Override
    public LockMap getLockMap() {
        return this._lockMap;
    }

    @Override
    public ObjectCopyStrategy getCopyStrategy(Identity identity) {
        Class<?> clazz = identity.getClass();
        if (OjbCloneable.class.isAssignableFrom(clazz)) {
            return this._cloneableCopyStrategy;
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return this._defaultCopyStrategy;
        }
        return this._noOpCopyStrategy;
    }

    @Override
    public boolean isImplicitLockingUsed() {
        return true;
    }

    @Override
    public boolean isInsertVerified() {
        return false;
    }

    @Override
    public boolean isEagerInsert(Object object) {
        return false;
    }
}

