/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.util;

import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionType;

public class CodeTranslator {
    public static final Map<String, String> arLabels = CodeTranslator.getArLabels();
    public static final Map<String, String> atLabels = CodeTranslator.getAtLabels();
    public static final Map<String, String> arStatusLabels = CodeTranslator.getArStatusLabels();
    public static final Map<String, String> routeStatusLabels = CodeTranslator.getRouteStatusLabels();
    public static final Map<Boolean, String> activeIndicatorLabels = CodeTranslator.getActiveIndicatorLabels();
    public static final Map<String, String> activationPolicyLabels = CodeTranslator.getActivationPolicyLabels();
    public static final Map<String, String> policyLabels = CodeTranslator.getPolicyLabels();
    public static final Map<String, String> approvePolicyLabels = CodeTranslator.getApprovePolicyLabels();

    private static Map<String, String> getAtLabels() {
        HashMap<String, String> newAtLabels = new HashMap<String, String>();
        newAtLabels.put("K", "ACKNOWLEDGED");
        newAtLabels.put("H", "ADHOC ROUTED");
        newAtLabels.put("V", "ADHOC REVOKED");
        newAtLabels.put("A", "APPROVED");
        newAtLabels.put("B", "BLANKET APPROVED");
        newAtLabels.put("X", "CANCELED");
        newAtLabels.put(ActionType.RECALL.getCode(), ActionType.RECALL.getLabel());
        newAtLabels.put("C", "COMPLETED");
        newAtLabels.put("O", "ROUTED");
        newAtLabels.put("D", "DISAPPROVED");
        newAtLabels.put("F", "FYI");
        newAtLabels.put("S", "SAVED");
        newAtLabels.put("Z", "RETURNED TO PREVIOUS ROUTE LEVEL");
        newAtLabels.put("R", "LOG MESSAGE");
        newAtLabels.put("M", "MOVED");
        newAtLabels.put("a", "SUPER USER APPROVED");
        newAtLabels.put("c", "SUPER USER CANCELED");
        newAtLabels.put("d", "SUPER USER DISAPPROVED");
        newAtLabels.put("r", "SUPER USER ROUTE LEVEL APPROVED");
        newAtLabels.put("v", "SUPER USER ACTION REQUEST APPROVED");
        newAtLabels.put("z", "SUPER USER RETURNED TO PREVIOUS ROUTE LEVEL");
        newAtLabels.put("k", "SUPER USER ACTION REQUEST ACKNOWLEDGED");
        newAtLabels.put("f", "SUPER USER ACTION REQUEST FYI");
        newAtLabels.put("m", "SUPER USER ACTION REQUEST COMPLETED");
        newAtLabels.put("w", "WORKGROUP AUTHORITY TAKEN");
        newAtLabels.put("y", "WORKGROUP AUTHORITY RELEASED");
        return newAtLabels;
    }

    private static Map<String, String> getArLabels() {
        HashMap<String, String> newArLabels = new HashMap<String, String>();
        newArLabels.put("K", "ACKNOWLEDGE");
        newArLabels.put("A", "APPROVE");
        newArLabels.put("C", "COMPLETE");
        newArLabels.put("F", "FYI");
        return newArLabels;
    }

    private static Map<String, String> getArStatusLabels() {
        HashMap<String, String> newArStatusLabels = new HashMap<String, String>();
        newArStatusLabels.put(ActionRequestStatus.ACTIVATED.getCode(), "ACTIVE");
        newArStatusLabels.put(ActionRequestStatus.INITIALIZED.getCode(), ActionRequestStatus.INITIALIZED.getLabel());
        newArStatusLabels.put(ActionRequestStatus.DONE.getCode(), ActionRequestStatus.DONE.getLabel());
        return newArStatusLabels;
    }

    private static Map<String, String> getRouteStatusLabels() {
        HashMap<String, String> newRouteStatusLabels = new HashMap<String, String>();
        newRouteStatusLabels.put("X", "CANCELED");
        newRouteStatusLabels.put("D", "DISAPPROVED");
        newRouteStatusLabels.put("R", "ENROUTE");
        newRouteStatusLabels.put("E", "EXCEPTION");
        newRouteStatusLabels.put("F", "FINAL");
        newRouteStatusLabels.put("I", "INITIATED");
        newRouteStatusLabels.put("P", "PROCESSED");
        newRouteStatusLabels.put("S", "SAVED");
        return newRouteStatusLabels;
    }

    private static Map<Boolean, String> getActiveIndicatorLabels() {
        HashMap<Boolean, String> newActiveIndicatorLabels = new HashMap<Boolean, String>();
        newActiveIndicatorLabels.put(Boolean.TRUE, "Active");
        newActiveIndicatorLabels.put(Boolean.FALSE, "Inactive");
        return newActiveIndicatorLabels;
    }

    private static Map<String, String> getPolicyLabels() {
        HashMap<String, String> newDocTypeActiveIndicatorLabels = new HashMap<String, String>();
        newDocTypeActiveIndicatorLabels.put("1", "Yes");
        newDocTypeActiveIndicatorLabels.put("0", "No");
        newDocTypeActiveIndicatorLabels.put("I", "Inherited");
        return newDocTypeActiveIndicatorLabels;
    }

    private static Map<String, String> getActivationPolicyLabels() {
        HashMap<String, String> newActivationPolicyLabels = new HashMap<String, String>();
        newActivationPolicyLabels.put("P", "PARALLEL");
        newActivationPolicyLabels.put("S", "SEQUENCE");
        newActivationPolicyLabels.put("R", "PRIORITY-PARALLEL");
        return newActivationPolicyLabels;
    }

    private static Map<String, String> getApprovePolicyLabels() {
        HashMap<String, String> approvePolicyLabels = new HashMap<String, String>();
        approvePolicyLabels.put(ActionRequestPolicy.ALL.getCode(), ActionRequestPolicy.ALL.getLabel());
        approvePolicyLabels.put(ActionRequestPolicy.FIRST.getCode(), ActionRequestPolicy.FIRST.getLabel());
        return approvePolicyLabels;
    }

    public static String getActionRequestLabel(String actionRequestCode) {
        return arLabels.get(actionRequestCode);
    }

    public static String getActionTakenLabel(String actionTakenCode) {
        return atLabels.get(actionTakenCode);
    }

    public static String getActionRequestStatusLabel(String status) {
        return arStatusLabels.get(status);
    }

    public static String getRouteStatusLabel(String status) {
        return routeStatusLabels.get(status);
    }

    public static String getActiveIndicatorLabel(Boolean indicator) {
        return activeIndicatorLabels.get(indicator);
    }

    public static String getActivationPolicyLabel(String code) {
        return activationPolicyLabels.get(code);
    }

    public static String getPolicyLabel(String code) {
        return policyLabels.get(code);
    }
}

