/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;

public class CSSCodec
extends Codec {
    private static final Character REPLACEMENT = Character.valueOf('\ufffd');

    @Override
    public String encodeCharacter(char[] immune, Character c) {
        if (CSSCodec.containsCharacter(c.charValue(), immune)) {
            return "" + c;
        }
        String hex = Codec.getHexForNonAlphanumeric(c.charValue());
        if (hex == null) {
            return "" + c;
        }
        return "\\" + hex + " ";
    }

    @Override
    public Character decodeCharacter(PushbackString input) {
        Character c;
        int i;
        input.mark();
        Character first = input.next();
        if (first == null || first.charValue() != '\\') {
            input.reset();
            return null;
        }
        Character second = input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        switch (second.charValue()) {
            case '\r': {
                if (input.peek('\n')) {
                    input.next();
                }
            }
            case '\u0000': 
            case '\n': 
            case '\f': {
                return this.decodeCharacter(input);
            }
        }
        if (!PushbackString.isHexDigit(second)) {
            return second;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(second);
        for (i = 0; i < 5 && (c = input.next()) != null && !Character.isWhitespace(c.charValue()); ++i) {
            if (!PushbackString.isHexDigit(c)) {
                input.pushback(c);
                break;
            }
            sb.append(c);
        }
        try {
            i = Integer.parseInt(sb.toString(), 16);
            if (Character.isValidCodePoint(i)) {
                return Character.valueOf((char)i);
            }
            return REPLACEMENT;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Received a NumberFormateException parsing a string verified to be hex", e);
        }
    }
}

