/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.web.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.coreservice.impl.component.ComponentBo;
import org.kuali.rice.coreservice.impl.component.DerivedComponentBo;
import org.kuali.rice.coreservice.impl.parameter.ParameterBo;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ParameterLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 4381873774407301041L;
    private static final String COMPONENT_NAME = "component.name";
    private static final String COMPONENT_CODE = "componentCode";

    protected boolean allowsMaintenanceEditAction(BusinessObject businessObject) {
        ParameterBo parm = (ParameterBo)businessObject;
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", parm.getNamespaceCode());
        permissionDetails.put("componentName", parm.getComponentCode());
        permissionDetails.put("parameterName", parm.getName());
        return KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "KR-NS", "Maintain System Parameter", permissionDetails, Collections.emptyMap());
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        if (fieldValues.containsKey(COMPONENT_NAME) && fieldValues.containsKey(COMPONENT_CODE)) {
            fieldValues.remove(COMPONENT_CODE);
            fieldValues.put(COMPONENT_CODE, "");
        }
        Object componentNameFieldValue = fieldValues.get(COMPONENT_NAME);
        fieldValues.remove(COMPONENT_NAME);
        List results = super.getSearchResultsUnbounded(fieldValues);
        this.normalizeParameterComponents(results);
        if (!StringUtils.isBlank((String)componentNameFieldValue)) {
            componentNameFieldValue = ((String)componentNameFieldValue).trim();
            componentNameFieldValue = ((String)componentNameFieldValue).replace("*", ".*");
            componentNameFieldValue = ".*" + (String)componentNameFieldValue + ".*";
            Pattern pattern = Pattern.compile((String)componentNameFieldValue, 2);
            Iterator resultsIter = results.iterator();
            while (resultsIter.hasNext()) {
                ParameterBo result = (ParameterBo)resultsIter.next();
                ComponentBo component = result.getComponent();
                if (component == null || pattern.matcher(component.getName()).matches()) continue;
                resultsIter.remove();
            }
        }
        return results;
    }

    private void normalizeParameterComponents(List<ParameterBo> parameters) {
        for (ParameterBo parameterBo : parameters) {
            if (parameterBo.getComponent() != null) continue;
            parameterBo.setComponent(DerivedComponentBo.toComponentBo((DerivedComponentBo)parameterBo.getDerivedComponent()));
        }
    }
}

