/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.framework.country;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;

public abstract class AbstractCountryValuesFinderBase
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        Country defaultCountry = this.getDefaultCountry();
        ArrayList<Country> countries = new ArrayList<Country>(this.retrieveCountriesForValuesFinder());
        ArrayList<KeyValue> values = new ArrayList<KeyValue>(countries.size() + 1);
        values.add((KeyValue)new ConcreteKeyValue("", ""));
        if (defaultCountry != null) {
            values.add((KeyValue)new ConcreteKeyValue(defaultCountry.getCode(), defaultCountry.getName()));
        }
        Collections.sort(countries, new Comparator<Country>(){

            @Override
            public int compare(Country country1, Country country2) {
                String sortValue1 = StringUtils.trim((String)StringUtils.removeStart((String)country1.getName(), (String)"*"));
                String sortValue2 = StringUtils.trim((String)StringUtils.removeStart((String)country2.getName(), (String)"*"));
                return sortValue1.compareToIgnoreCase(sortValue2);
            }
        });
        for (Country country : countries) {
            if (!country.isActive()) continue;
            values.add((KeyValue)new ConcreteKeyValue(country.getCode(), country.getName()));
        }
        return values;
    }

    protected abstract List<Country> retrieveCountriesForValuesFinder();

    protected Country getDefaultCountry() {
        return LocationApiServiceLocator.getCountryService().getDefaultCountry();
    }
}

