/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.locking;

import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.util.LoggerFacade;

public class ReadWriteUpgradeLock
extends GenericLock {
    public static final int NO_LOCK = 0;
    public static final int READ_LOCK = 1;
    public static final int UPGRADE_LOCK = 2;
    public static final int WRITE_LOCK = 3;

    public ReadWriteUpgradeLock(Object resourceId, LoggerFacade logger) {
        super(resourceId, 3, logger);
    }

    public boolean acquireRead(Object ownerId, long timeoutMSecs) throws InterruptedException {
        return this.acquire(ownerId, 1, true, true, timeoutMSecs);
    }

    public boolean acquireUpgrade(Object ownerId, long timeoutMSecs) throws InterruptedException {
        return this.acquire(ownerId, 2, true, true, timeoutMSecs);
    }

    public boolean acquireWrite(Object ownerId, long timeoutMSecs) throws InterruptedException {
        boolean preferred = this.getLockLevel(ownerId) == 2;
        return this.acquire(ownerId, 3, true, 1, preferred, timeoutMSecs);
    }

    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean wait, int compatibility, boolean preferred, long timeoutMSecs) throws InterruptedException {
        if (targetLockLevel == 3 && this.getLockLevel(ownerId) == 2) {
            preferred = true;
        }
        return super.acquire(ownerId, targetLockLevel, wait, compatibility, preferred, timeoutMSecs);
    }
}

