/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.transaction.locking.ReadWriteLockManager;
import org.apache.commons.transaction.memory.HashMapFactory;
import org.apache.commons.transaction.memory.HashSetFactory;
import org.apache.commons.transaction.memory.MapFactory;
import org.apache.commons.transaction.memory.SetFactory;
import org.apache.commons.transaction.memory.TransactionalMapWrapper;
import org.apache.commons.transaction.util.LoggerFacade;

public class PessimisticMapWrapper
extends TransactionalMapWrapper {
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final Object GLOBAL_LOCK = "GLOBAL";
    protected ReadWriteLockManager lockManager;
    protected long readTimeOut = 60000L;

    public PessimisticMapWrapper(Map wrapped, LoggerFacade logger) {
        this(wrapped, new HashMapFactory(), new HashSetFactory(), logger);
    }

    public PessimisticMapWrapper(Map wrapped, MapFactory mapFactory, SetFactory setFactory, LoggerFacade logger) {
        super(wrapped, mapFactory, setFactory);
        this.lockManager = new ReadWriteLockManager(logger, this.readTimeOut);
    }

    public void startTransaction() {
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " already associated with a transaction!");
        }
        LockingTxContext context = new LockingTxContext();
        this.setActiveTx(context);
    }

    public Collection values() {
        this.assureGlobalReadLock();
        return super.values();
    }

    public Set entrySet() {
        this.assureGlobalReadLock();
        return super.entrySet();
    }

    public Set keySet() {
        this.assureGlobalReadLock();
        return super.keySet();
    }

    public Object remove(Object key) {
        this.assureWriteLock(key);
        return super.remove(key);
    }

    public Object put(Object key, Object value) {
        this.assureWriteLock(key);
        return super.put(key, value);
    }

    protected void assureWriteLock(Object key) {
        LockingTxContext txContext = (LockingTxContext)this.getActiveTx();
        if (txContext != null) {
            this.lockManager.writeLock(txContext, key);
            this.lockManager.readLock(txContext, GLOBAL_LOCK);
        }
    }

    protected void assureGlobalReadLock() {
        LockingTxContext txContext = (LockingTxContext)this.getActiveTx();
        if (txContext != null) {
            this.lockManager.readLock(txContext, GLOBAL_LOCK);
        }
    }

    public class LockingTxContext
    extends TransactionalMapWrapper.TxContext {
        public LockingTxContext() {
            super(PessimisticMapWrapper.this);
        }

        protected Set keys() {
            PessimisticMapWrapper.this.lockManager.readLock(this, GLOBAL_LOCK);
            return super.keys();
        }

        protected Object get(Object key) {
            PessimisticMapWrapper.this.lockManager.readLock(this, key);
            PessimisticMapWrapper.this.lockManager.readLock(this, GLOBAL_LOCK);
            return super.get(key);
        }

        protected void put(Object key, Object value) {
            PessimisticMapWrapper.this.lockManager.writeLock(this, key);
            PessimisticMapWrapper.this.lockManager.readLock(this, GLOBAL_LOCK);
            super.put(key, value);
        }

        protected void remove(Object key) {
            PessimisticMapWrapper.this.lockManager.writeLock(this, key);
            PessimisticMapWrapper.this.lockManager.readLock(this, GLOBAL_LOCK);
            super.remove(key);
        }

        protected int size() {
            PessimisticMapWrapper.this.lockManager.readLock(this, GLOBAL_LOCK);
            return super.size();
        }

        protected void clear() {
            PessimisticMapWrapper.this.lockManager.writeLock(this, GLOBAL_LOCK);
            super.clear();
        }

        protected void dispose() {
            super.dispose();
            PessimisticMapWrapper.this.lockManager.releaseAll(this);
        }

        protected void finalize() throws Throwable {
            this.dispose();
            super.finalize();
        }
    }
}

