/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.admin.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.ksb.messaging.web.KSBAction;
import org.kuali.rice.ksb.security.admin.ExportServlet;
import org.kuali.rice.ksb.security.admin.web.JavaSecurityManagementForm;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class JavaSecurityManagementAction
extends KSBAction {
    private static final Logger LOG = LogManager.getLogger(JavaSecurityManagementAction.class);

    @Override
    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm form) throws Exception {
        request.setAttribute("rice_constant", this.getServlet().getServletContext().getAttribute("RiceConstants"));
        request.setAttribute("entryListPageSize", (Object)30);
        List keyStoreEntryList = KSBServiceLocator.getJavaSecurityManagementService().getListOfModuleKeyStoreEntries();
        LOG.info("Found " + keyStoreEntryList.size() + " entries in module keystore");
        request.setAttribute("keyStoreEntryList", (Object)keyStoreEntryList);
        return null;
    }

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("report");
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("report");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form = new JavaSecurityManagementForm();
        return mapping.findForward("restart");
    }

    public ActionForward removeEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String aliasToRemove = request.getParameter("aliasToRemove");
        LOG.info("Removing alias " + aliasToRemove + " from module keystore file");
        KSBServiceLocator.getJavaSecurityManagementService().removeClientCertificate(aliasToRemove);
        return mapping.findForward("restart");
    }

    public ActionForward generateClientKeyStore(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JavaSecurityManagementForm managementForm = (JavaSecurityManagementForm)form;
        ActionErrors errors = managementForm.validateGenerateClientKeystore(mapping, request);
        if (errors == null || errors.isEmpty()) {
            KeyStore clientKeyStore = KSBServiceLocator.getJavaSecurityManagementService().generateClientKeystore(managementForm.getAlias(), managementForm.getPassword());
            byte[] data = new byte[]{};
            ByteArrayOutputStream baos = null;
            try {
                baos = new ByteArrayOutputStream();
                clientKeyStore.store(baos, managementForm.getPassword().toCharArray());
                data = baos.toByteArray();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (CertificateException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            form = new JavaSecurityManagementForm();
            request.getSession().setAttribute("ClientKeyStoreData", (Object)data);
            return new ActionForward(ExportServlet.generateExportPath((String)(managementForm.getAlias() + "_keystore"), (HttpServletRequest)request), true);
        }
        this.saveErrors(request, (ActionMessages)errors);
        return mapping.findForward("report");
    }
}

