/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.api.campus;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.location.api.campus.CampusContract;
import org.kuali.rice.location.api.campus.CampusType;
import org.w3c.dom.Element;

@XmlRootElement(name="campus")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CampusType", propOrder={"code", "name", "shortName", "campusType", "active", "versionNumber", "objectId", "_futureElements"})
public final class Campus
extends AbstractDataTransferObject
implements CampusContract {
    private static final long serialVersionUID = 2288194493838509380L;
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElement(name="shortName", required=false)
    private final String shortName;
    @XmlElement(name="campusType", required=false)
    private final CampusType campusType;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Campus() {
        this.code = null;
        this.name = null;
        this.shortName = null;
        this.campusType = null;
        this.active = false;
        this.versionNumber = null;
        this.objectId = null;
    }

    private Campus(Builder builder) {
        this.code = builder.getCode();
        this.name = builder.getName();
        this.shortName = builder.getShortName();
        this.campusType = builder.campusType != null ? builder.getCampusType().build() : null;
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public CampusType getCampusType() {
        return this.campusType;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/location/v2_0/CampusType";
    }

    static class Elements {
        static final String CODE = "code";
        static final String NAME = "name";
        static final String SHORT_NAME = "shortName";
        static final String CAMPUS_TYPE = "campusType";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "campus";
        static final String TYPE_NAME = "CampusType";

        Constants() {
        }
    }

    public static class Builder
    implements CampusContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -3130728718673871762L;
        private String code;
        private String name;
        private String shortName;
        private CampusType.Builder campusType;
        private boolean active;
        private Long versionNumber;
        private String objectId;

        private Builder(String code) {
            this.setCode(code);
            this.setActive(true);
        }

        public static Builder create(String code) {
            return new Builder(code);
        }

        public static Builder create(CampusContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getCode());
            builder.setName(contract.getName());
            builder.setShortName(contract.getShortName());
            if (contract.getCampusType() != null) {
                builder.setCampusType(CampusType.Builder.create(contract.getCampusType()));
            }
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public void setCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("code is blank");
            }
            this.code = code;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public void setCampusType(CampusType.Builder campusType) {
            this.campusType = campusType;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public String getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public CampusType.Builder getCampusType() {
            return this.campusType;
        }

        public boolean isActive() {
            return this.active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public Campus build() {
            return new Campus(this);
        }
    }
}

