/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBindingContract;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBindingQueryResults;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBo;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBoService;

public class ReferenceObjectBindingBoServiceImpl
implements ReferenceObjectBindingBoService {
    private DataObjectService dataObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }

    public KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    @Override
    public ReferenceObjectBinding createReferenceObjectBinding(ReferenceObjectBinding referenceObjectBinding) {
        this.incomingParamCheck(referenceObjectBinding, "referenceObjectBinding");
        String referenceObjectBindingIdKey = referenceObjectBinding.getId();
        ReferenceObjectBinding existing = this.getReferenceObjectBinding(referenceObjectBindingIdKey);
        if (existing != null) {
            throw new IllegalStateException("the ReferenceObjectBinding to create already exists: " + referenceObjectBinding);
        }
        ReferenceObjectBindingBo bo = (ReferenceObjectBindingBo)this.dataObjectService.save((Object)this.from(referenceObjectBinding), new PersistenceOption[]{PersistenceOption.FLUSH});
        return ReferenceObjectBindingBo.to(bo);
    }

    @Override
    public ReferenceObjectBinding getReferenceObjectBinding(String referenceObjectBindingId) {
        this.incomingParamCheck(referenceObjectBindingId, "referenceObjectBindingId");
        ReferenceObjectBindingBo bo = (ReferenceObjectBindingBo)this.dataObjectService.find(ReferenceObjectBindingBo.class, (Object)referenceObjectBindingId);
        return ReferenceObjectBindingBo.to(bo);
    }

    @Override
    public ReferenceObjectBinding updateReferenceObjectBinding(ReferenceObjectBinding referenceObjectBinding) {
        ReferenceObjectBinding toUpdate;
        this.incomingParamCheck(referenceObjectBinding, "referenceObjectBinding");
        ReferenceObjectBinding existing = this.getReferenceObjectBinding(referenceObjectBinding.getId());
        if (existing == null) {
            throw new IllegalStateException("the ReferenceObjectBinding to update does not exists: " + referenceObjectBinding);
        }
        if (!existing.getId().equals(referenceObjectBinding.getId())) {
            ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)referenceObjectBinding);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = referenceObjectBinding;
        }
        ReferenceObjectBindingBo boToUpdate = this.from(toUpdate);
        ReferenceObjectBindingBo updatedData = (ReferenceObjectBindingBo)this.dataObjectService.save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
        return this.to(updatedData);
    }

    @Override
    public void deleteReferenceObjectBinding(String referenceObjectBindingId) {
        this.incomingParamCheck(referenceObjectBindingId, "referenceObjectBindingId");
        ReferenceObjectBinding existing = this.getReferenceObjectBinding(referenceObjectBindingId);
        if (existing == null) {
            throw new IllegalStateException("the ReferenceObjectBinding to delete does not exists: " + referenceObjectBindingId);
        }
        this.dataObjectService.delete((Object)this.from(existing));
    }

    @Override
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByCollectionName(String collectionName) {
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalArgumentException("collectionName is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("collectionName", collectionName);
        List<ReferenceObjectBindingBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, ReferenceObjectBindingBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsDiscriminatorType(String krmsDiscriminatorType) {
        if (StringUtils.isBlank((String)krmsDiscriminatorType)) {
            throw new IllegalArgumentException("krmsDiscriminatorType is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("krmsDiscriminatorType", krmsDiscriminatorType);
        List<ReferenceObjectBindingBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, ReferenceObjectBindingBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsObject(String krmsObjectId) {
        if (StringUtils.isBlank((String)krmsObjectId)) {
            throw new IllegalArgumentException("krmsObjectId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("krmsObjectId", krmsObjectId);
        List<ReferenceObjectBindingBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, ReferenceObjectBindingBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        List<ReferenceObjectBindingBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, ReferenceObjectBindingBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceDiscriminatorType(String referenceDiscriminatorType) {
        if (StringUtils.isBlank((String)referenceDiscriminatorType)) {
            throw new IllegalArgumentException("referenceDiscriminatorType is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("referenceDiscriminatorType", referenceDiscriminatorType);
        List<ReferenceObjectBindingBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, ReferenceObjectBindingBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceObject(String referenceObjectId) {
        if (StringUtils.isBlank((String)referenceObjectId)) {
            throw new IllegalArgumentException("referenceObjectId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("referenceObjectId", referenceObjectId);
        List<ReferenceObjectBindingBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, ReferenceObjectBindingBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<String> findReferenceObjectBindingIds(QueryByCriteria queryByCriteria) {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        ReferenceObjectBindingQueryResults results = this.findReferenceObjectBindings(queryByCriteria);
        ArrayList<String> result = new ArrayList<String>();
        for (ReferenceObjectBinding referenceObjectBinding : results.getResults()) {
            result.add(referenceObjectBinding.getId());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ReferenceObjectBindingQueryResults findReferenceObjectBindings(QueryByCriteria queryByCriteria) {
        QueryResults results = this.dataObjectService.findMatching(ReferenceObjectBindingBo.class, queryByCriteria);
        ReferenceObjectBindingQueryResults.Builder builder = ReferenceObjectBindingQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<ReferenceObjectBinding.Builder> ims = new ArrayList<ReferenceObjectBinding.Builder>();
        for (ReferenceObjectBindingBo bo : results.getResults()) {
            ims.add(ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public List<ReferenceObjectBinding> convertBosToImmutables(Collection<ReferenceObjectBindingBo> referenceObjectBindingBos) {
        LinkedList<ReferenceObjectBinding> immutables = new LinkedList<ReferenceObjectBinding>();
        if (referenceObjectBindingBos != null) {
            ReferenceObjectBinding immutable = null;
            for (ReferenceObjectBindingBo bo : referenceObjectBindingBos) {
                immutable = this.to(bo);
                immutables.add(immutable);
            }
        }
        return Collections.unmodifiableList(immutables);
    }

    @Override
    public ReferenceObjectBinding to(ReferenceObjectBindingBo referenceObjectBindingBo) {
        return ReferenceObjectBindingBo.to(referenceObjectBindingBo);
    }

    @Override
    public ReferenceObjectBindingBo from(ReferenceObjectBinding referenceObjectBinding) {
        return ReferenceObjectBindingBo.from(referenceObjectBinding);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new IllegalArgumentException(name + " was blank");
        }
    }
}

