/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="inactivationBlockingDefinition")
public class InactivationBlockingDefinition
extends DataDictionaryDefinitionBase
implements InactivationBlockingMetadata {
    private static final long serialVersionUID = -8765429636173190984L;
    protected Class<?> blockingReferenceBusinessObjectClass;
    protected String blockedReferencePropertyName;
    protected Class<?> blockedBusinessObjectClass;
    protected String inactivationBlockingDetectionServiceBeanName;
    protected String relationshipLabel;
    protected Class<?> businessObjectClass;

    @Override
    public void completeValidation(Class<?> rootDataObjectClass, Class<?> otherDataObjectClass, ValidationTrace tracer) {
        String[] currentValues;
        if (StringUtils.isBlank((String)this.inactivationBlockingDetectionServiceBeanName) && StringUtils.isBlank((String)this.blockedReferencePropertyName)) {
            currentValues = new String[]{"rootDataObjectClass = " + rootDataObjectClass};
            tracer.createError("inactivationBlockingDetectionServiceBeanName and  blockedReferencePropertyName can't both be blank in InactivationBlockingDefinition", currentValues);
        }
        if (this.getBlockedDataObjectClass() == null) {
            currentValues = new String[]{"rootDataObjectClass = " + rootDataObjectClass};
            tracer.createError("Unable to determine blockedReferenceBusinessObjectClass in InactivationBlockingDefinition", currentValues);
        }
    }

    @Override
    @Deprecated
    @BeanTagAttribute(name="blockedReferencePropertyName")
    public String getBlockedReferencePropertyName() {
        return this.blockedReferencePropertyName;
    }

    @Deprecated
    public void setBlockedReferencePropertyName(String blockedReferencePropertyName) {
        this.blockedReferencePropertyName = blockedReferencePropertyName;
    }

    @Override
    @BeanTagAttribute(name="blockedAttributeName")
    public String getBlockedAttributeName() {
        return this.blockedReferencePropertyName;
    }

    public void setBlockedAttributeName(String blockedAttributeName) {
        this.blockedReferencePropertyName = blockedAttributeName;
    }

    @Override
    @Deprecated
    @BeanTagAttribute(name="blockedBusinessObjectClass")
    public Class<? extends BusinessObject> getBlockedBusinessObjectClass() {
        return this.blockedBusinessObjectClass;
    }

    @Deprecated
    public void setBlockedBusinessObjectClass(Class<? extends BusinessObject> blockedBusinessObjectClass) {
        this.blockedBusinessObjectClass = blockedBusinessObjectClass;
    }

    @Override
    @BeanTagAttribute(name="blockedDataObjectClass")
    public Class<?> getBlockedDataObjectClass() {
        return this.blockedBusinessObjectClass;
    }

    public void setBlockedDataObjectClass(Class<?> blockedDataObjectClass) {
        this.blockedBusinessObjectClass = blockedDataObjectClass;
    }

    @Override
    @BeanTagAttribute(name="inactivationBlockingDetectionServiceBeanName")
    public String getInactivationBlockingDetectionServiceBeanName() {
        return this.inactivationBlockingDetectionServiceBeanName;
    }

    public void setInactivationBlockingDetectionServiceBeanName(String inactivationBlockingDetectionServiceImpl) {
        this.inactivationBlockingDetectionServiceBeanName = inactivationBlockingDetectionServiceImpl;
    }

    @Override
    @Deprecated
    @BeanTagAttribute(name="blockingReferenceBusinessObjectClass")
    public Class<? extends BusinessObject> getBlockingReferenceBusinessObjectClass() {
        return this.blockingReferenceBusinessObjectClass;
    }

    @Deprecated
    public void setBlockingReferenceBusinessObjectClass(Class<? extends BusinessObject> blockingReferenceBusinessObjectClass) {
        this.blockingReferenceBusinessObjectClass = blockingReferenceBusinessObjectClass;
    }

    @Override
    @BeanTagAttribute(name="blockingDataObjectClass")
    public Class<?> getBlockingDataObjectClass() {
        return this.blockingReferenceBusinessObjectClass;
    }

    public void setBlockingReferenceDataObjectClass(Class<?> blockingDataObjectClass) {
        this.blockingReferenceBusinessObjectClass = blockingDataObjectClass;
    }

    @Override
    @BeanTagAttribute(name="relationshipLabel")
    public String getRelationshipLabel() {
        return this.relationshipLabel;
    }

    public void setRelationshipLabel(String relationshipLabel) {
        this.relationshipLabel = relationshipLabel;
    }

    @Deprecated
    @BeanTagAttribute(name="businessObjectClass")
    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    @Deprecated
    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    public String toString() {
        return "InactivationBlockingDefinition: blockedClass=" + this.blockedBusinessObjectClass.getName() + " /blockingReferenceProperty=" + this.blockedReferencePropertyName + " /blockingClass=" + this.blockingReferenceBusinessObjectClass.getName();
    }
}

