/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.DictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validator.ErrorReport;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="constraint")
public class BaseConstraint
extends DictionaryBeanBase
implements Constraint {
    private static final long serialVersionUID = -2891712660500311114L;
    protected String messageNamespaceCode;
    protected String messageComponentCode;
    protected String messageKey;
    protected Boolean applyClientSide = true;
    protected List<String> validationMessageParams;
    protected List<String> states;
    protected List<? extends BaseConstraint> constraintStateOverrides;

    @BeanTagAttribute(name="messageNamespaceCode")
    public String getMessageNamespaceCode() {
        return this.messageNamespaceCode;
    }

    public void setMessageNamespaceCode(String messageNamespaceCode) {
        this.messageNamespaceCode = messageNamespaceCode;
    }

    @BeanTagAttribute(name="messageComponentCode")
    public String getMessageComponentCode() {
        return this.messageComponentCode;
    }

    public void setMessageComponentCode(String messageComponentCode) {
        this.messageComponentCode = messageComponentCode;
    }

    @BeanTagAttribute(name="messageKey")
    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    @BeanTagAttribute(name="applyClientSide")
    public Boolean getApplyClientSide() {
        return this.applyClientSide;
    }

    public void setApplyClientSide(Boolean applyClientSide) {
        this.applyClientSide = applyClientSide;
    }

    @BeanTagAttribute(name="validationMessageParams", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getValidationMessageParams() {
        return this.validationMessageParams;
    }

    public String[] getValidationMessageParamsArray() {
        if (this.getValidationMessageParams() != null) {
            return this.getValidationMessageParams().toArray(new String[this.getValidationMessageParams().size()]);
        }
        return null;
    }

    public void setValidationMessageParams(List<String> validationMessageParams) {
        this.validationMessageParams = validationMessageParams;
    }

    @BeanTagAttribute(name="states", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getStates() {
        if (this.states == null) {
            this.states = new ArrayList<String>();
        }
        return this.states;
    }

    public void setStates(List<String> states) {
        this.states = states;
    }

    @BeanTagAttribute(name="constraintStateOverrides", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<? extends BaseConstraint> getConstraintStateOverrides() {
        return this.constraintStateOverrides;
    }

    public void setConstraintStateOverrides(List<? extends BaseConstraint> constraintStateOverrides) {
        if (constraintStateOverrides != null) {
            for (BaseConstraint baseConstraint : constraintStateOverrides) {
                if (!baseConstraint.getClass().equals(this.getClass())) {
                    Class<?> o;
                    ArrayList superClasses = new ArrayList();
                    for (o = baseConstraint.getClass(); o != null && !o.equals(BaseConstraint.class); o = o.getSuperclass()) {
                        superClasses.add(o);
                    }
                    ArrayList thisSuperClasses = new ArrayList();
                    for (o = this.getClass(); o != null && !o.equals(BaseConstraint.class); o = o.getSuperclass()) {
                        thisSuperClasses.add(o);
                    }
                    superClasses.retainAll(thisSuperClasses);
                    if (superClasses.isEmpty()) {
                        throw new RuntimeException("Constraint State Override is not a correct type, type should be " + this.getClass().toString() + " (or child/parent of that constraint type)");
                    }
                }
                if (!baseConstraint.getStates().isEmpty()) continue;
                throw new RuntimeException("Constraint State Overrides MUST declare the states they apply to.  No stateswere declared.");
            }
        }
        this.constraintStateOverrides = constraintStateOverrides;
    }

    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean("BaseConstraint", this.getMessageKey());
        if (this.getConstraintStateOverrides() != null) {
            for (int i = 0; i < this.constraintStateOverrides.size(); ++i) {
                if (this.constraintStateOverrides.get(i).getStates() == null) {
                    String[] currentValues = new String[]{"constraintStateOverrides(" + i + ").messageKey =" + this.constraintStateOverrides.get(i).getMessageKey()};
                    tracer.createError("Constraints set in State Overrides must have there states property set", currentValues);
                }
                this.constraintStateOverrides.get(i).completeValidation(tracer.getCopy());
            }
        }
        if (this.getMessageKey() == null) {
            String[] currentValues = new String[]{"messageKey =" + this.getMessageKey()};
            tracer.createWarning("Message key is not set", currentValues);
            ErrorReport errorReport = new ErrorReport(2);
        }
    }
}

