/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.element.GroupValidationMessages;
import org.kuali.rice.krad.uif.lifecycle.LifecycleEventListener;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

@BeanTag(name="pageValidationMessages", parent="Uif-PageValidationMessages")
public class PageValidationMessages
extends GroupValidationMessages
implements LifecycleEventListener {
    private static final long serialVersionUID = 6387432156428507958L;
    private boolean showPageSummaryHeader;

    @Override
    public void generateMessages(View view, Object model, Component parent) {
        super.generateMessages(view, model, parent);
        ViewLifecycle viewLifecycle = ViewLifecycle.getActiveLifecycle();
        viewLifecycle.registerLifecycleCompleteListener(view, this);
    }

    @Override
    protected void addValidationMessageDataAttributes(Component parent) {
    }

    @Override
    public void processEvent(ViewLifecycle.LifecycleEvent lifecycleEvent, View view, Object model, LifecycleElement eventElement) {
        View eventComponent = (View)eventElement;
        PageGroup currentPage = eventComponent.getCurrentPage();
        HashSet<String> allPossibleKeys = new HashSet<String>();
        Set<String> renderedPropertyPaths = ViewLifecycle.getViewPostMetadata().getAllRenderedPropertyPaths();
        if (renderedPropertyPaths != null) {
            allPossibleKeys.addAll(renderedPropertyPaths);
        }
        this.addNestedGroupKeys(allPossibleKeys, currentPage);
        if (this.getAdditionalKeysToMatch() != null) {
            allPossibleKeys.addAll(this.getAdditionalKeysToMatch());
        }
        if (StringUtils.isNotBlank((String)currentPage.getId())) {
            allPossibleKeys.add(currentPage.getId());
        }
        MessageMap messageMap = GlobalVariables.getMessageMap();
        HashSet messageKeys = new HashSet();
        messageKeys.addAll(messageMap.getAllPropertiesWithErrors());
        messageKeys.addAll(messageMap.getAllPropertiesWithWarnings());
        messageKeys.addAll(messageMap.getAllPropertiesWithInfo());
        messageKeys.removeAll(allPossibleKeys);
        for (String key : messageKeys) {
            this.getErrors().addAll(this.getMessages(view, key, messageMap.getErrorMessagesForProperty(key, true)));
            this.getWarnings().addAll(this.getMessages(view, key, messageMap.getWarningMessagesForProperty(key, true)));
            this.getInfos().addAll(this.getMessages(view, key, messageMap.getInfoMessagesForProperty(key, true)));
        }
        super.addValidationMessageDataAttributes(currentPage);
    }

    @BeanTagAttribute
    public boolean isShowPageSummaryHeader() {
        return this.showPageSummaryHeader;
    }

    public void setShowPageSummaryHeader(boolean showPageSummaryHeader) {
        this.showPageSummaryHeader = showPageSummaryHeader;
    }
}

