/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.util.DefaultThreadFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;

public final class UtilityElf {
    public static final boolean IS_JAVA7;

    public static long elapsedTimeMs(long start) {
        return System.currentTimeMillis() - start;
    }

    public static void quietlySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setRemoveOnCancelPolicy(ScheduledThreadPoolExecutor executor) {
        if (IS_JAVA7) {
            executor.setRemoveOnCancelPolicy(true);
        }
    }

    public static <T> T createInstance(String className, Class<T> clazz, Object ... args) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> loaded = UtilityElf.class.getClassLoader().loadClass(className);
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            if (args.length > 0) {
                Constructor<?> constructor = loaded.getConstructor(argClasses);
                return (T)constructor.newInstance(args);
            }
            return (T)loaded.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int queueSize, String threadName, ThreadFactory threadFactory, RejectedExecutionHandler policy) {
        if (threadFactory == null) {
            threadFactory = new DefaultThreadFactory(threadName, true);
        }
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, queue, threadFactory, policy);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static int getTransactionIsolation(String transactionIsolationName) {
        if (transactionIsolationName != null) {
            try {
                Field field = Connection.class.getField(transactionIsolationName);
                return field.getInt(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid transaction isolation value: " + transactionIsolationName);
            }
        }
        return -1;
    }

    static {
        boolean b = false;
        try {
            b = AbstractQueuedLongSynchronizer.class.getMethod("hasQueuedPredecessors", new Class[0]) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_JAVA7 = b;
    }
}

