/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.resourceloader;

import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderContainer;
import org.kuali.rice.core.api.resourceloader.ServiceLocator;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.framework.resourceloader.ObjectDefinitionResolver;

public class BaseResourceLoader
extends ResourceLoaderContainer
implements ResourceLoader {
    protected static final Logger LOG = LogManager.getLogger(BaseResourceLoader.class);
    private ServiceLocator serviceLocator;
    private ClassLoader classLoader;
    private boolean postProcessContainer = true;

    public BaseResourceLoader(QName name, ClassLoader classLoader) {
        this(name, classLoader, null);
    }

    public BaseResourceLoader(QName name) {
        this(name, ClassLoaderUtils.getDefaultClassLoader());
    }

    public BaseResourceLoader(QName name, ServiceLocator serviceLocator) {
        this(name, ClassLoaderUtils.getDefaultClassLoader(), serviceLocator);
    }

    public BaseResourceLoader(QName name, ClassLoader classLoader, ServiceLocator serviceLocator) {
        super(name);
        this.classLoader = classLoader;
        this.serviceLocator = serviceLocator;
    }

    public Object getObject(ObjectDefinition objectDefinition) {
        Object object = ObjectDefinitionResolver.createObject(objectDefinition, this.classLoader, true);
        if (object != null) {
            return this.postProcessObject(objectDefinition, object);
        }
        Object superObject = super.getObject(objectDefinition);
        return this.isPostProcessContainer() ? this.postProcessObject(objectDefinition, superObject) : superObject;
    }

    public Object getService(QName serviceName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ResourceLoader " + this.getName() + " fetching service " + serviceName + this.getMemStatus());
        }
        if (this.serviceLocator != null) {
            Object service;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using internal service locator to fetch service " + serviceName);
            }
            if ((service = this.serviceLocator.getService(serviceName)) != null) {
                return this.postProcessService(serviceName, service);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ResourceLoader " + this.getName() + " didn't find service differing to child resource loaders ");
        }
        Object superService = super.getService(serviceName);
        return this.isPostProcessContainer() ? this.postProcessService(serviceName, superService) : superService;
    }

    public void start() throws Exception {
        if (this.classLoader instanceof Lifecycle) {
            ((Lifecycle)this.classLoader).start();
        }
        if (this.serviceLocator != null) {
            LOG.info("Starting ResourceLoader " + this.getName());
            this.serviceLocator.start();
        }
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        if (this.serviceLocator != null) {
            LOG.info("Stopping ResourceLoader " + this.getName());
            this.serviceLocator.stop();
        }
        if (this.classLoader instanceof Lifecycle) {
            ((Lifecycle)this.classLoader).stop();
        }
        this.classLoader = null;
        this.serviceLocator = null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Object postProcessObject(ObjectDefinition definition, Object object) {
        return object;
    }

    protected Object postProcessService(QName serviceName, Object service) {
        return service;
    }

    public boolean isPostProcessContainer() {
        return this.postProcessContainer;
    }

    public void setPostProcessContainer(boolean postProcessContainer) {
        this.postProcessContainer = postProcessContainer;
    }

    public String getContents(String indent, boolean servicePerLine) {
        String contents = indent + this + "\n";
        if (this.serviceLocator != null) {
            contents = contents + this.serviceLocator.getContents(indent + "+++", servicePerLine);
        }
        for (ResourceLoader resourceLoader : this.getResourceLoaders()) {
            contents = contents + resourceLoader.getContents(indent + "+++", servicePerLine);
        }
        return contents;
    }

    private String getMemStatus() {
        return "\n############################################################## \n# " + this.dumpMemory() + "\n##############################################################\n";
    }

    private String dumpMemory() {
        long total = Runtime.getRuntime().totalMemory() / 1024L;
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        long max = Runtime.getRuntime().maxMemory() / 1024L;
        return "[Memory] max: " + max + "K, total: " + total + "K, free: " + free + "K, used: " + (total - free) + "K";
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }
}

