/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.resourceloader;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.core.api.reflect.DataDefinition;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.reflect.PropertyDefinition;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderBinder;

public class ObjectDefinitionResolver {
    public static Object wrap(Object object) {
        return ObjectDefinitionResolver.wrap(object, ClassLoaderUtils.getDefaultClassLoader());
    }

    public static Object wrap(Object object, ClassLoader classLoader) {
        return object;
    }

    public static Object createObject(String className, ClassLoader classLoader) {
        return ObjectDefinitionResolver.createObject(new ObjectDefinition(className), classLoader, true);
    }

    public static Object createObject(final ObjectDefinition definition, final ClassLoader classLoader, final boolean wrap) {
        Object result = null;
        final String className = definition.getClassName();
        try {
            result = ContextClassLoaderBinder.doInContextClassLoader((ClassLoader)classLoader, (Callable)new Callable(){

                public Object call() throws Exception {
                    Object object = null;
                    Class<?>[] constructorParamTypes = ObjectDefinitionResolver.buildConstructorParamTypes(definition.getConstructorParameters());
                    Object[] constructorParams = ObjectDefinitionResolver.buildConstructorParams(definition.getConstructorParameters());
                    try {
                        Class<?> objectClass = Class.forName(className, true, classLoader);
                        object = ObjectDefinitionResolver.loadObject(objectClass, constructorParams, constructorParamTypes);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                    ObjectDefinitionResolver.invokeProperties(object, definition.getProperties());
                    if (wrap) {
                        return ObjectDefinitionResolver.wrap(object, classLoader);
                    }
                    return object;
                }
            });
        }
        catch (Exception e) {
            ObjectDefinitionResolver.handleException(className, e);
        }
        return result;
    }

    protected static Object loadObject(Class<?> objectClass, Object[] constructorParams, Class<?>[] constructorParamTypes) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ConstructorUtils.invokeConstructor(objectClass, (Object[])constructorParams, (Class[])constructorParamTypes);
    }

    private static void handleException(String className, Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new ResourceLoaderException("Could not materialize object from definition, using classname: " + className, (Throwable)e);
    }

    protected static Class<?>[] buildConstructorParamTypes(List<DataDefinition> constructorParameters) {
        Class[] params = new Class[constructorParameters.size()];
        int index = 0;
        for (DataDefinition dataDef : constructorParameters) {
            params[index++] = dataDef.getType();
        }
        return params;
    }

    protected static Object[] buildConstructorParams(List<DataDefinition> constructorParameters) {
        Object[] params = new Object[constructorParameters.size()];
        int index = 0;
        for (DataDefinition dataDef : constructorParameters) {
            params[index++] = dataDef.getValue();
        }
        return params;
    }

    protected static void invokeProperties(Object object, Collection<PropertyDefinition> properties) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        for (PropertyDefinition propertyDef : properties) {
            ObjectDefinitionResolver.invokeProperty(object, propertyDef);
        }
    }

    protected static void invokeProperty(Object object, PropertyDefinition definition) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        PropertyUtils.setProperty((Object)object, (String)definition.getName(), (Object)definition.getData().getValue());
    }
}

