/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.personal;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographicsContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityBioDemographics")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityBioDemographicsType", propOrder={"entityId", "deceasedDate", "birthDate", "age", "genderCode", "genderChangeCode", "maritalStatusCode", "primaryLanguageCode", "secondaryLanguageCode", "birthCountry", "birthStateProvinceCode", "birthCity", "geographicOrigin", "birthDateUnmasked", "genderCodeUnmasked", "genderChangeCodeUnmasked", "maritalStatusCodeUnmasked", "primaryLanguageCodeUnmasked", "secondaryLanguageCodeUnmasked", "birthCountryUnmasked", "birthStateProvinceCodeUnmasked", "birthCityUnmasked", "geographicOriginUnmasked", "noteMessage", "suppressPersonal", "versionNumber", "objectId", "_futureElements"})
public final class EntityBioDemographics
extends AbstractDataTransferObject
implements EntityBioDemographicsContract {
    private static final Logger LOG = LogManager.getLogger(EntityBioDemographics.class);
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="deceasedDate", required=false)
    private final String deceasedDate;
    @XmlElement(name="birthDate", required=false)
    private final String birthDate;
    @XmlElement(name="genderCode", required=false)
    private final String genderCode;
    @XmlElement(name="genderChangeCode", required=false)
    private final String genderChangeCode;
    @XmlElement(name="maritalStatusCode", required=false)
    private final String maritalStatusCode;
    @XmlElement(name="primaryLanguageCode", required=false)
    private final String primaryLanguageCode;
    @XmlElement(name="secondaryLanguageCode", required=false)
    private final String secondaryLanguageCode;
    @XmlElement(name="birthCountry", required=false)
    private final String birthCountry;
    @XmlElement(name="birthStateProvinceCode", required=false)
    private final String birthStateProvinceCode;
    @XmlElement(name="birthCity", required=false)
    private final String birthCity;
    @XmlElement(name="geographicOrigin", required=false)
    private final String geographicOrigin;
    @XmlElement(name="birthDateUnmasked", required=false)
    private final String birthDateUnmasked;
    @XmlElement(name="genderCodeUnmasked", required=false)
    private final String genderCodeUnmasked;
    @XmlElement(name="genderChangeCodeUnmasked", required=false)
    private final String genderChangeCodeUnmasked;
    @XmlElement(name="maritalStatusCodeUnmasked", required=false)
    private final String maritalStatusCodeUnmasked;
    @XmlElement(name="primaryLanguageCodeUnmasked", required=false)
    private final String primaryLanguageCodeUnmasked;
    @XmlElement(name="secondaryLanguageCodeUnmasked", required=false)
    private final String secondaryLanguageCodeUnmasked;
    @XmlElement(name="birthCountryUnmasked", required=false)
    private final String birthCountryUnmasked;
    @XmlElement(name="birthStateProvinceCodeUnmasked", required=false)
    private final String birthStateProvinceCodeUnmasked;
    @XmlElement(name="birthCityUnmasked", required=false)
    private final String birthCityUnmasked;
    @XmlElement(name="geographicOriginUnmasked", required=false)
    private final String geographicOriginUnmasked;
    @XmlElement(name="noteMessage", required=false)
    private final String noteMessage;
    @XmlElement(name="suppressPersonal", required=true)
    private final boolean suppressPersonal;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityBioDemographics() {
        this.entityId = null;
        this.deceasedDate = null;
        this.birthDate = null;
        this.genderCode = null;
        this.genderChangeCode = null;
        this.maritalStatusCode = null;
        this.primaryLanguageCode = null;
        this.secondaryLanguageCode = null;
        this.birthCountry = null;
        this.birthStateProvinceCode = null;
        this.birthCity = null;
        this.geographicOrigin = null;
        this.birthDateUnmasked = null;
        this.genderCodeUnmasked = null;
        this.genderChangeCodeUnmasked = null;
        this.maritalStatusCodeUnmasked = null;
        this.primaryLanguageCodeUnmasked = null;
        this.secondaryLanguageCodeUnmasked = null;
        this.birthCountryUnmasked = null;
        this.birthStateProvinceCodeUnmasked = null;
        this.birthCityUnmasked = null;
        this.geographicOriginUnmasked = null;
        this.noteMessage = null;
        this.suppressPersonal = false;
        this.versionNumber = null;
        this.objectId = null;
    }

    private EntityBioDemographics(Builder builder) {
        this.entityId = builder.getEntityId();
        this.deceasedDate = builder.getDeceasedDate();
        this.birthDate = builder.getBirthDate();
        this.genderCode = builder.getGenderCode();
        this.genderChangeCode = builder.getGenderChangeCode();
        this.maritalStatusCode = builder.getMaritalStatusCode();
        this.primaryLanguageCode = builder.getPrimaryLanguageCode();
        this.secondaryLanguageCode = builder.getSecondaryLanguageCode();
        this.birthCountry = builder.getBirthCountry();
        this.birthStateProvinceCode = builder.getBirthStateProvinceCode();
        this.birthCity = builder.getBirthCity();
        this.geographicOrigin = builder.getGeographicOrigin();
        this.birthDateUnmasked = builder.getBirthDateUnmasked();
        this.genderCodeUnmasked = builder.getGenderCodeUnmasked();
        this.genderChangeCodeUnmasked = builder.getGenderChangeCodeUnmasked();
        this.maritalStatusCodeUnmasked = builder.getMaritalStatusCodeUnmasked();
        this.primaryLanguageCodeUnmasked = builder.getPrimaryLanguageCodeUnmasked();
        this.secondaryLanguageCodeUnmasked = builder.getSecondaryLanguageCodeUnmasked();
        this.birthCountryUnmasked = builder.getBirthCountryUnmasked();
        this.birthStateProvinceCodeUnmasked = builder.getBirthStateProvinceCodeUnmasked();
        this.birthCityUnmasked = builder.getBirthCityUnmasked();
        this.geographicOriginUnmasked = builder.getGeographicOriginUnmasked();
        this.noteMessage = builder.getNoteMessage();
        this.suppressPersonal = builder.isSuppressPersonal();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getDeceasedDate() {
        return this.deceasedDate;
    }

    @Override
    public String getBirthDate() {
        return this.birthDate;
    }

    @Override
    @XmlElement(name="age", required=true)
    public Integer getAge() {
        return EntityBioDemographics.calculateAge(this.birthDate, this.deceasedDate, this.isSuppressPersonal());
    }

    @Override
    public String getGenderCode() {
        return this.genderCode;
    }

    @Override
    public String getGenderChangeCode() {
        return this.genderChangeCode;
    }

    @Override
    public String getMaritalStatusCode() {
        return this.maritalStatusCode;
    }

    @Override
    public String getPrimaryLanguageCode() {
        return this.primaryLanguageCode;
    }

    @Override
    public String getSecondaryLanguageCode() {
        return this.secondaryLanguageCode;
    }

    @Override
    public String getBirthCountry() {
        return this.birthCountry;
    }

    @Override
    public String getBirthStateProvinceCode() {
        return this.birthStateProvinceCode;
    }

    @Override
    public String getBirthCity() {
        return this.birthCity;
    }

    @Override
    public String getGeographicOrigin() {
        return this.geographicOrigin;
    }

    @Override
    public String getBirthDateUnmasked() {
        return this.birthDateUnmasked;
    }

    @Override
    public String getGenderCodeUnmasked() {
        return this.genderCodeUnmasked;
    }

    @Override
    public String getGenderChangeCodeUnmasked() {
        return this.genderChangeCodeUnmasked;
    }

    @Override
    public String getMaritalStatusCodeUnmasked() {
        return this.maritalStatusCodeUnmasked;
    }

    @Override
    public String getPrimaryLanguageCodeUnmasked() {
        return this.primaryLanguageCodeUnmasked;
    }

    @Override
    public String getSecondaryLanguageCodeUnmasked() {
        return this.secondaryLanguageCodeUnmasked;
    }

    @Override
    public String getBirthCountryUnmasked() {
        return this.birthCountryUnmasked;
    }

    @Override
    public String getBirthStateProvinceCodeUnmasked() {
        return this.birthStateProvinceCodeUnmasked;
    }

    @Override
    public String getBirthCityUnmasked() {
        return this.birthCityUnmasked;
    }

    @Override
    public String getGeographicOriginUnmasked() {
        return this.geographicOriginUnmasked;
    }

    @Override
    public String getNoteMessage() {
        return this.noteMessage;
    }

    @Override
    public boolean isSuppressPersonal() {
        return this.suppressPersonal;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    private static Integer calculateAge(String birthDate, String deceasedDate, boolean suppressPersonal) {
        if (birthDate != null && !suppressPersonal) {
            DateTime endDate;
            Date parsedBirthDate;
            try {
                parsedBirthDate = new SimpleDateFormat("yyyy-MM-dd").parse(birthDate);
            }
            catch (ParseException pe) {
                LOG.error("Error parsing EntityBioDemographics birth date: '" + birthDate + "'", (Throwable)pe);
                return null;
            }
            if (deceasedDate != null) {
                try {
                    endDate = new DateTime((Object)new SimpleDateFormat("yyyy-MM-dd").parse(deceasedDate));
                }
                catch (ParseException pe) {
                    LOG.error("Error parsing EntityBioDemographics deceased date: '" + deceasedDate + "'", (Throwable)pe);
                    return null;
                }
            } else {
                endDate = new DateTime();
            }
            return Years.yearsBetween((ReadableInstant)new DateTime((Object)parsedBirthDate), (ReadableInstant)endDate).getYears();
        }
        return null;
    }

    static class Elements {
        static final String ENTITY_ID = "entityId";
        static final String DECEASED_DATE = "deceasedDate";
        static final String BIRTH_DATE = "birthDate";
        static final String AGE = "age";
        static final String GENDER_CODE = "genderCode";
        static final String MARITAL_STATUS_CODE = "maritalStatusCode";
        static final String PRIMARY_LANGUAGE_CODE = "primaryLanguageCode";
        static final String SECONDARY_LANGUAGE_CODE = "secondaryLanguageCode";
        static final String BIRTH_COUNTRY = "birthCountry";
        static final String BIRTH_STATE_PROVINCE_CODE = "birthStateProvinceCode";
        static final String BIRTH_CITY = "birthCity";
        static final String GEOGRAPHIC_ORIGIN = "geographicOrigin";
        static final String BIRTH_DATE_UNMASKED = "birthDateUnmasked";
        static final String GENDER_CODE_UNMASKED = "genderCodeUnmasked";
        static final String MARITAL_STATUS_CODE_UNMASKED = "maritalStatusCodeUnmasked";
        static final String PRIMARY_LANGUAGE_CODE_UNMASKED = "primaryLanguageCodeUnmasked";
        static final String SECONDARY_LANGUAGE_CODE_UNMASKED = "secondaryLanguageCodeUnmasked";
        static final String BIRTH_COUNTRY_UNMASKED = "birthCountryUnmasked";
        static final String BIRTH_STATE_PROVINCE_CODE_UNMASKED = "birthStateProvinceCodeUnmasked";
        static final String BIRTH_CITY_UNMASKED = "birthCityUnmasked";
        static final String GEOGRAPHIC_ORIGIN_UNMASKED = "geographicOriginUnmasked";
        static final String GENDER_CHANGE_CODE = "genderChangeCode";
        static final String GENDER_CHANGE_CODE_UNMASKED = "genderChangeCodeUnmasked";
        static final String NOTE_MESSAGE = "noteMessage";
        static final String SUPPRESS_PERSONAL = "suppressPersonal";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityBioDemographics";
        static final String TYPE_NAME = "EntityBioDemographicsType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityBioDemographicsContract {
        private String entityId;
        private String deceasedDate;
        private String birthDate;
        private String genderCode;
        private String maritalStatusCode;
        private String primaryLanguageCode;
        private String secondaryLanguageCode;
        private String birthCountry;
        private String birthStateProvinceCode;
        private String birthCity;
        private String geographicOrigin;
        private String genderChangeCode;
        private String noteMessage;
        private boolean suppressPersonal;
        private Long versionNumber;
        private String objectId;

        private Builder(String entityId, String genderCode) {
            this.setEntityId(entityId);
            this.setGenderCode(genderCode);
        }

        public static Builder create(String entityId, String genderCode) {
            return new Builder(entityId, genderCode);
        }

        public static Builder create(EntityBioDemographicsContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getEntityId(), contract.getGenderCode());
            builder.setDeceasedDate(contract.getDeceasedDate());
            builder.setBirthDate(contract.getBirthDate());
            builder.setMaritalStatusCode(contract.getMaritalStatusCode());
            builder.setPrimaryLanguageCode(contract.getPrimaryLanguageCode());
            builder.setSecondaryLanguageCode(contract.getSecondaryLanguageCode());
            builder.setBirthCountry(contract.getBirthCountry());
            builder.setBirthStateProvinceCode(contract.getBirthStateProvinceCode());
            builder.setBirthCity(contract.getBirthCity());
            builder.setGeographicOrigin(contract.getGeographicOrigin());
            builder.setGenderChangeCode(contract.getGenderChangeCode());
            builder.setNoteMessage(contract.getNoteMessage());
            builder.setSuppressPersonal(contract.isSuppressPersonal());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public EntityBioDemographics build() {
            return new EntityBioDemographics(this);
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public String getDeceasedDate() {
            return this.deceasedDate;
        }

        @Override
        public String getBirthDate() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.birthDate;
        }

        @Override
        public Integer getAge() {
            return EntityBioDemographics.calculateAge(this.birthDate, this.deceasedDate, this.isSuppressPersonal());
        }

        @Override
        public String getGenderCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.genderCode;
        }

        @Override
        public String getGenderChangeCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.genderChangeCode;
        }

        @Override
        public String getMaritalStatusCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.maritalStatusCode;
        }

        @Override
        public String getPrimaryLanguageCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.primaryLanguageCode;
        }

        @Override
        public String getSecondaryLanguageCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.secondaryLanguageCode;
        }

        @Override
        public String getBirthCountry() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.birthCountry;
        }

        @Override
        public String getBirthStateProvinceCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.birthStateProvinceCode;
        }

        @Override
        public String getBirthCity() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.birthCity;
        }

        @Override
        public String getGeographicOrigin() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.geographicOrigin;
        }

        @Override
        public String getBirthDateUnmasked() {
            return this.birthDate;
        }

        @Override
        public String getGenderCodeUnmasked() {
            return this.genderCode;
        }

        @Override
        public String getGenderChangeCodeUnmasked() {
            return this.genderChangeCode;
        }

        @Override
        public String getMaritalStatusCodeUnmasked() {
            return this.maritalStatusCode;
        }

        @Override
        public String getPrimaryLanguageCodeUnmasked() {
            return this.primaryLanguageCode;
        }

        @Override
        public String getSecondaryLanguageCodeUnmasked() {
            return this.secondaryLanguageCode;
        }

        @Override
        public String getBirthCountryUnmasked() {
            return this.birthCountry;
        }

        @Override
        public String getBirthStateProvinceCodeUnmasked() {
            return this.birthStateProvinceCode;
        }

        @Override
        public String getBirthCityUnmasked() {
            return this.birthCity;
        }

        @Override
        public String getGeographicOriginUnmasked() {
            return this.geographicOrigin;
        }

        @Override
        public String getNoteMessage() {
            return this.noteMessage;
        }

        @Override
        public boolean isSuppressPersonal() {
            return this.suppressPersonal;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setEntityId(String entityId) {
            if (StringUtils.isEmpty((String)entityId)) {
                throw new IllegalArgumentException("id is empty");
            }
            this.entityId = entityId;
        }

        public void setDeceasedDate(String deceasedDate) {
            if (deceasedDate != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    format.parse(deceasedDate);
                    this.deceasedDate = deceasedDate;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("deceasedDate is not of the format 'yyyy-MM-DD'", e);
                }
            }
        }

        public void setBirthDate(String birthDate) {
            if (birthDate != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    format.parse(birthDate);
                    this.birthDate = birthDate;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("birthDate is not of the format 'yyyy-MM-DD'", e);
                }
            }
        }

        public void setDeceasedDate(Date deceasedDate) {
            this.deceasedDate = new SimpleDateFormat("yyyy-MM-dd").format(deceasedDate);
        }

        public void setBirthDate(Date birthDate) {
            this.birthDate = new SimpleDateFormat("yyyy-MM-dd").format(birthDate);
        }

        public void setGenderCode(String genderCode) {
            if (StringUtils.isEmpty((String)genderCode)) {
                throw new IllegalArgumentException("genderCode is empty");
            }
            this.genderCode = genderCode;
        }

        public void setGenderChangeCode(String genderChangeCode) {
            this.genderChangeCode = genderChangeCode;
        }

        public void setMaritalStatusCode(String maritalStatusCode) {
            this.maritalStatusCode = maritalStatusCode;
        }

        public void setPrimaryLanguageCode(String primaryLanguageCode) {
            this.primaryLanguageCode = primaryLanguageCode;
        }

        public void setSecondaryLanguageCode(String secondaryLanguageCode) {
            this.secondaryLanguageCode = secondaryLanguageCode;
        }

        public void setBirthCountry(String birthCountry) {
            this.birthCountry = birthCountry;
        }

        public void setBirthStateProvinceCode(String birthStateProvinceCode) {
            this.birthStateProvinceCode = birthStateProvinceCode;
        }

        public void setBirthCity(String birthCity) {
            this.birthCity = birthCity;
        }

        public void setGeographicOrigin(String geographicOrigin) {
            this.geographicOrigin = geographicOrigin;
        }

        private void setNoteMessage(String noteMessage) {
            this.noteMessage = noteMessage;
        }

        private void setSuppressPersonal(boolean suppressPersonal) {
            this.suppressPersonal = suppressPersonal;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }
}

