/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property;

import com.codiform.moo.IncompatibleTypeTranslationException;
import com.codiform.moo.NullUnsupportedTranslationException;
import com.codiform.moo.annotation.Optionality;
import com.codiform.moo.property.Property;
import com.codiform.moo.translator.PrimitiveAssignment;

public abstract class AbstractProperty
implements Property {
    @Override
    public boolean canSupportNull() {
        return !this.getType().isPrimitive();
    }

    protected boolean isSourceRequired(boolean defaultSetting, Optionality optionality) {
        if (optionality == null) {
            return defaultSetting;
        }
        switch (optionality) {
            case REQUIRED: {
                return true;
            }
            case OPTIONAL: {
                return false;
            }
        }
        return defaultSetting;
    }

    protected void checkValue(Object value) {
        if (value == null) {
            if (!this.canSupportNull()) {
                throw new NullUnsupportedTranslationException(this.getName(), this.getType());
            }
        } else if (this.getType().isPrimitive() ? !PrimitiveAssignment.isCompatible(this.getType(), value.getClass()) : (value.getClass().isPrimitive() ? !PrimitiveAssignment.isCompatible(value.getClass(), this.getType()) : !this.getType().isAssignableFrom(value.getClass()))) {
            throw new IncompatibleTypeTranslationException(value, this.getName(), this.getType());
        }
    }

    @Override
    public boolean isTypeOrSubtype(Class<?> type) {
        return type.isAssignableFrom(this.getType());
    }
}

