/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.TranslationInitializationException;
import com.codiform.moo.translator.TranslationTargetFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DefaultObjectTargetFactory
implements TranslationTargetFactory {
    @Override
    public <T> T getTranslationTargetInstance(Object source, Class<T> targetType) {
        try {
            Constructor<T> constructor = targetType.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new TranslationInitializationException("No no-argument constructor in class " + targetType.getName(), exception);
        }
        catch (InstantiationException exception) {
            throw new TranslationInitializationException(String.format("Error while instantiating %s", targetType), exception);
        }
        catch (IllegalAccessException exception) {
            throw new TranslationInitializationException(String.format("Not allowed to instantiate %s", targetType), exception);
        }
        catch (IllegalArgumentException exception) {
            throw new TranslationInitializationException(String.format("Error while instantiating %s", targetType), exception);
        }
        catch (InvocationTargetException exception) {
            throw new TranslationInitializationException(String.format("Error thrown by constructor of %s", targetType), exception);
        }
    }
}

