/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.bus;

import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.serviceconnectors.ServiceConnectorFactory;

public class LazyEndpoint
implements Endpoint {
    private final Object lock = new Object();
    private final ServiceConfiguration serviceConfiguration;
    private volatile Object service;

    public LazyEndpoint(ServiceConfiguration serviceConfiguration) {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException("serviceConfiguration was null");
        }
        this.serviceConfiguration = serviceConfiguration;
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService() {
        Object internalService = this.service;
        if (internalService == null) {
            Object object = this.lock;
            synchronized (object) {
                internalService = this.service;
                if (internalService == null) {
                    this.service = internalService = ServiceConnectorFactory.getServiceConnector(this.serviceConfiguration).getService();
                }
            }
        }
        return internalService;
    }
}

