/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.bus;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ChecksumUtils;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.registry.ServiceDescriptor;
import org.kuali.rice.ksb.api.registry.ServiceEndpoint;
import org.kuali.rice.ksb.api.registry.ServiceEndpointStatus;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.impl.bus.ServiceConfigurationSerializationHandler;

public final class LocalService {
    private final ServiceDefinition serviceDefinition;
    private final Endpoint endpoint;
    private final ServiceEndpoint serviceEndpoint;

    LocalService(String instanceId, ServiceDefinition serviceDefinition) {
        this(instanceId, serviceDefinition, null);
    }

    LocalService(String instanceId, ServiceDefinition serviceDefinition, ServiceEndpoint serviceEndpoint) {
        if (StringUtils.isBlank((String)instanceId)) {
            throw new IllegalArgumentException("instanceId was blank or null");
        }
        if (serviceDefinition == null) {
            throw new IllegalArgumentException("serviceDefinition was null");
        }
        this.serviceDefinition = serviceDefinition;
        this.endpoint = serviceDefinition.establishEndpoint();
        this.serviceEndpoint = serviceEndpoint != null ? serviceEndpoint : LocalService.constructServiceEndpoint(instanceId, this.endpoint);
    }

    LocalService(LocalService currentLocalService, ServiceEndpoint newServiceEndpoint) {
        this(newServiceEndpoint.getInfo().getInstanceId(), currentLocalService.getServiceDefinition(), newServiceEndpoint);
    }

    public QName getServiceName() {
        return this.endpoint.getServiceConfiguration().getServiceName();
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    static ServiceEndpoint constructServiceEndpoint(String instanceId, Endpoint endpoint) {
        ServiceInfo.Builder serviceInfo = LocalService.constructServiceInfo(instanceId, endpoint.getServiceConfiguration());
        ServiceDescriptor.Builder serviceDescriptor = LocalService.constructDescriptor(endpoint.getServiceConfiguration());
        ServiceEndpoint.Builder builder = ServiceEndpoint.Builder.create((ServiceInfo.Builder)serviceInfo, (ServiceDescriptor.Builder)serviceDescriptor);
        return builder.build();
    }

    static ServiceInfo.Builder constructServiceInfo(String instanceId, ServiceConfiguration serviceConfiguration) {
        ServiceInfo.Builder builder = ServiceInfo.Builder.create();
        builder.setInstanceId(instanceId);
        builder.setApplicationId(serviceConfiguration.getApplicationId());
        builder.setChecksum(ChecksumUtils.calculateChecksum((Object)serviceConfiguration));
        builder.setEndpointUrl(serviceConfiguration.getEndpointUrl().toExternalForm());
        builder.setServerIpAddress(RiceUtilities.getIpNumber());
        builder.setServiceName(serviceConfiguration.getServiceName());
        builder.setServiceVersion(serviceConfiguration.getServiceVersion());
        builder.setStatus(ServiceEndpointStatus.ONLINE);
        builder.setType(serviceConfiguration.getType());
        return builder;
    }

    static ServiceDescriptor.Builder constructDescriptor(ServiceConfiguration serviceConfiguration) {
        ServiceDescriptor.Builder builder = ServiceDescriptor.Builder.create();
        builder.setDescriptor(ServiceConfigurationSerializationHandler.marshallToXml(serviceConfiguration));
        return builder;
    }
}

