/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.security.Signature;
import java.security.cert.Certificate;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequest;
import org.kuali.rice.ksb.security.AbstractDigitalSigner;

public class HttpClientHeaderDigitalSigner
extends AbstractDigitalSigner {
    private HttpRequest method;
    private String alias;
    private Certificate certificate;

    public HttpClientHeaderDigitalSigner(Signature signature, HttpRequest method, String alias) {
        super(signature);
        this.method = method;
        this.alias = alias;
    }

    public HttpClientHeaderDigitalSigner(Signature signature, HttpRequest method, String alias, Certificate certificate) {
        this(signature, method, alias);
        this.certificate = certificate;
    }

    public HttpClientHeaderDigitalSigner(Signature signature, HttpRequest method, Certificate certificate) {
        super(signature);
        this.method = method;
        this.certificate = certificate;
    }

    @Override
    public void sign() throws Exception {
        if (StringUtils.isNotBlank((String)this.alias)) {
            this.method.addHeader("KEW_KEYSTORE_ALIAS", this.alias);
        }
        if (this.certificate != null) {
            this.method.addHeader("KEW_CERTIFICATE_ALIAS", this.getEncodedCertificate(this.certificate));
        }
        this.method.addHeader("KEW_DIGITAL_SIGNATURE", this.getEncodedSignature());
    }
}

