/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RsIterator;
import org.apache.ojb.broker.accesslayer.RsQueryObject;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;
import org.apache.ojb.broker.query.ReportQuery;

public class ReportQueryRsIterator
extends RsIterator {
    private int m_attributeCount;
    private int[] m_jdbcTypes;

    public ReportQueryRsIterator(RsQueryObject rsQueryObject, PersistenceBrokerImpl persistenceBrokerImpl) {
        super(rsQueryObject, persistenceBrokerImpl);
        try {
            ReportQuery reportQuery = (ReportQuery)((Object)rsQueryObject.getQuery());
            this.m_attributeCount = reportQuery.getAttributes().length;
            this.init_jdbcTypes();
        }
        catch (SQLException sQLException) {
            this.releaseDbResources();
            throw new PersistenceBrokerException(sQLException);
        }
    }

    private void init_jdbcTypes() throws SQLException {
        ReportQuery reportQuery = (ReportQuery)((Object)this.getQueryObject().getQuery());
        this.m_jdbcTypes = new int[this.m_attributeCount];
        if (reportQuery.getJdbcTypes() != null) {
            this.m_jdbcTypes = reportQuery.getJdbcTypes();
        } else {
            ResultSetMetaData resultSetMetaData = this.getRsAndStmt().m_rs.getMetaData();
            for (int i = 0; i < this.m_attributeCount; ++i) {
                this.m_jdbcTypes[i] = resultSetMetaData.getColumnType(i + 1);
            }
        }
    }

    @Override
    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        Object[] objectArray = new Object[this.m_attributeCount];
        ReportQuery reportQuery = (ReportQuery)((Object)this.getQueryObject().getQuery());
        for (int i = 0; i < this.m_attributeCount; ++i) {
            try {
                int n = this.m_jdbcTypes[i];
                String string = reportQuery.getAttributes()[i];
                FieldDescriptor fieldDescriptor = (FieldDescriptor)reportQuery.getAttributeFieldDescriptors().get(string);
                Object object = JdbcTypesHelper.getObjectFromColumn(this.getRsAndStmt().m_rs, new Integer(n), i + 1);
                if (fieldDescriptor != null && fieldDescriptor.getFieldConversion() != null) {
                    object = fieldDescriptor.getFieldConversion().sqlToJava(object);
                }
                objectArray[i] = object;
                continue;
            }
            catch (SQLException sQLException) {
                throw new PersistenceBrokerException(sQLException);
            }
        }
        return objectArray;
    }
}

