/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.ojb.broker.accesslayer.sql.SelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlQueryStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;

public class SqlSelectStatement
extends SqlQueryStatement
implements SelectStatement {
    private WeakReference fieldsForSelect;

    public SqlSelectStatement(Platform platform, ClassDescriptor classDescriptor, Query query, Logger logger) {
        super(platform, classDescriptor, query, logger);
    }

    public SqlSelectStatement(SqlQueryStatement sqlQueryStatement, Platform platform, ClassDescriptor classDescriptor, Query query, Logger logger) {
        super(sqlQueryStatement, platform, classDescriptor, query, logger);
    }

    protected void appendColumn(SqlQueryStatement.TableAlias tableAlias, FieldDescriptor fieldDescriptor, StringBuffer stringBuffer) {
        stringBuffer.append(tableAlias.alias);
        stringBuffer.append(".");
        stringBuffer.append(fieldDescriptor.getColumnName());
    }

    protected List appendListOfColumnsForSelect(StringBuffer stringBuffer) {
        FieldDescriptor[] fieldDescriptorArray = this.getFieldsForSelect();
        ArrayList<String> arrayList = new ArrayList<String>();
        SqlQueryStatement.TableAlias tableAlias = this.getSearchTable();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            SqlQueryStatement.TableAlias tableAlias2 = this.getTableAliasForClassDescriptor(fieldDescriptor.getClassDescriptor());
            if (tableAlias2 == null) {
                tableAlias2 = tableAlias;
            }
            if (i > 0) {
                stringBuffer.append(",");
            }
            this.appendColumn(tableAlias2, fieldDescriptor, stringBuffer);
            arrayList.add(fieldDescriptor.getAttributeName());
        }
        this.appendClazzColumnForSelect(stringBuffer);
        return arrayList;
    }

    private ClassDescriptor[] getMultiJoinedClassDescriptors(ClassDescriptor classDescriptor) {
        DescriptorRepository descriptorRepository = classDescriptor.getRepository();
        Class[] classArray = descriptorRepository.getSubClassesMultipleJoinedTables(classDescriptor, true);
        ClassDescriptor[] classDescriptorArray = new ClassDescriptor[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classDescriptorArray[i] = descriptorRepository.getDescriptorFor(classArray[i]);
        }
        return classDescriptorArray;
    }

    private void appendClazzColumnForSelect(StringBuffer stringBuffer) {
        ClassDescriptor classDescriptor = this.getSearchClassDescriptor();
        ClassDescriptor[] classDescriptorArray = this.getMultiJoinedClassDescriptors(classDescriptor);
        if (classDescriptorArray.length == 0) {
            return;
        }
        stringBuffer.append(",CASE");
        for (int i = classDescriptorArray.length; i > 0; --i) {
            stringBuffer.append(" WHEN ");
            ClassDescriptor classDescriptor2 = classDescriptorArray[i - 1];
            FieldDescriptor[] fieldDescriptorArray = classDescriptor2.getPkFields();
            SqlQueryStatement.TableAlias tableAlias = this.getTableAliasForClassDescriptor(classDescriptor2);
            for (int j = 0; j < fieldDescriptorArray.length; ++j) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[j];
                if (j > 0) {
                    stringBuffer.append(" AND ");
                }
                this.appendColumn(tableAlias, fieldDescriptor, stringBuffer);
                stringBuffer.append(" IS NOT NULL");
            }
            stringBuffer.append(" THEN '").append(classDescriptor2.getClassNameOfObject()).append("'");
        }
        stringBuffer.append(" ELSE '").append(classDescriptor.getClassNameOfObject()).append("'");
        stringBuffer.append(" END AS OJB_CLAZZ");
    }

    protected FieldDescriptor[] getFieldsForSelect() {
        if (this.fieldsForSelect == null || this.fieldsForSelect.get() == null) {
            this.fieldsForSelect = new WeakReference<FieldDescriptor[]>(this.buildFieldsForSelect(this.getSearchClassDescriptor()));
        }
        return (FieldDescriptor[])this.fieldsForSelect.get();
    }

    protected FieldDescriptor[] buildFieldsForSelect(ClassDescriptor classDescriptor) {
        int n;
        DescriptorRepository descriptorRepository = classDescriptor.getRepository();
        ListOrderedSet listOrderedSet = new ListOrderedSet();
        FieldDescriptor[] fieldDescriptorArray = descriptorRepository.getFieldDescriptorsForMultiMappedTable(classDescriptor);
        for (n = 0; n < fieldDescriptorArray.length; ++n) {
            listOrderedSet.add(fieldDescriptorArray[n]);
        }
        fieldDescriptorArray = classDescriptor.getFieldDescriptor(true);
        for (n = 0; n < fieldDescriptorArray.length; ++n) {
            listOrderedSet.add(fieldDescriptorArray[n]);
        }
        Class[] classArray = descriptorRepository.getSubClassesMultipleJoinedTables(classDescriptor, true);
        for (int i = 0; i < classArray.length; ++i) {
            ClassDescriptor classDescriptor2 = descriptorRepository.getDescriptorFor(classArray[i]);
            fieldDescriptorArray = classDescriptor2.getFieldDescriptions();
            for (int j = 0; j < fieldDescriptorArray.length; ++j) {
                listOrderedSet.add(fieldDescriptorArray[j]);
            }
        }
        FieldDescriptor[] fieldDescriptorArray2 = new FieldDescriptor[listOrderedSet.size()];
        listOrderedSet.toArray(fieldDescriptorArray2);
        return fieldDescriptorArray2;
    }

    protected List appendListOfColumns(String[] stringArray, StringBuffer stringBuffer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            this.appendColName(stringArray[i], false, null, stringBuffer);
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    @Override
    protected String buildStatement() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        QueryByCriteria queryByCriteria = this.getQuery();
        boolean bl = true;
        List list = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        Iterator iterator = this.getJoinTreeToCriteria().entrySet().iterator();
        List list2 = new ArrayList();
        if (queryByCriteria instanceof ReportQuery) {
            stringArray = ((ReportQuery)((Object)queryByCriteria)).getAttributes();
            stringArray2 = ((ReportQuery)((Object)queryByCriteria)).getJoinAttributes();
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Criteria criteria = (Criteria)entry.getValue();
            Criteria criteria2 = queryByCriteria.getHavingCriteria();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            this.setRoot((SqlQueryStatement.TableAlias)entry.getKey());
            if (criteria != null && criteria.isEmpty()) {
                criteria = null;
            }
            if (criteria2 != null && criteria2.isEmpty()) {
                criteria2 = null;
            }
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" UNION ");
            }
            stringBuffer.append("SELECT ");
            if (queryByCriteria.isDistinct()) {
                stringBuffer.append("DISTINCT ");
            }
            if (stringArray == null || stringArray.length == 0) {
                list2.addAll(this.appendListOfColumnsForSelect(stringBuffer));
            } else {
                list2.addAll(this.appendListOfColumns(stringArray, stringBuffer));
            }
            if (stringArray2 != null && stringArray2.length > 0) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.getAttributeInfo(stringArray2[i], false, null, this.getQuery().getPathClasses());
                }
            }
            List list3 = queryByCriteria.getGroupBy();
            this.ensureColumns(list3, list2);
            list = queryByCriteria.getOrderBy();
            list2 = this.ensureColumns(list, list2, stringBuffer);
            ClassDescriptor classDescriptor = this.getBaseClassDescriptor();
            ClassDescriptor classDescriptor2 = null;
            if (classDescriptor.getSuperClass() != null) {
                classDescriptor2 = classDescriptor.getRepository().getDescriptorFor(classDescriptor.getSuperClass());
                this.appendSuperClassColumns(classDescriptor2, stringBuffer);
            }
            stringBuffer.append(" FROM ");
            this.appendTableWithJoins(this.getRoot(), stringBuffer2, stringBuffer);
            if (classDescriptor.getSuperClass() != null) {
                this.appendSuperClassJoin(classDescriptor, classDescriptor2, stringBuffer, stringBuffer2);
            }
            this.appendWhereClause(stringBuffer2, criteria, stringBuffer);
            this.appendGroupByClause(list3, stringBuffer);
            this.appendHavingClause(stringBuffer3, criteria2, stringBuffer);
        }
        this.appendOrderByClause(list, list2, stringBuffer);
        if (queryByCriteria instanceof ReportQueryByCriteria) {
            ((ReportQueryByCriteria)queryByCriteria).setAttributeFieldDescriptors(this.m_attrToFld);
        }
        return stringBuffer.toString();
    }

    private void appendSuperClassJoin(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        stringBuffer.append(",");
        this.appendTable(classDescriptor2, stringBuffer);
        if (stringBuffer2 != null) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(" AND ");
            }
            int n = classDescriptor.getSuperClassFieldRef();
            FieldDescriptor fieldDescriptor = classDescriptor.getFieldDescriptorByIndex(n);
            this.appendTable(classDescriptor2, stringBuffer2);
            stringBuffer2.append(".");
            this.appendField(classDescriptor2.getAutoIncrementFields()[0], stringBuffer2);
            stringBuffer2.append(" = ");
            this.appendTable(classDescriptor, stringBuffer2);
            stringBuffer2.append(".");
            this.appendField(fieldDescriptor, stringBuffer2);
        }
    }

    private void appendSuperClassColumns(ClassDescriptor classDescriptor, StringBuffer stringBuffer) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(classDescriptor.getFullTableName());
            stringBuffer.append(".");
            stringBuffer.append(fieldDescriptor.getColumnName());
        }
    }

    protected void appendTable(ClassDescriptor classDescriptor, StringBuffer stringBuffer) {
        stringBuffer.append(classDescriptor.getFullTableName());
    }

    protected void appendField(FieldDescriptor fieldDescriptor, StringBuffer stringBuffer) {
        stringBuffer.append(fieldDescriptor.getColumnName());
    }

    @Override
    public Query getQueryInstance() {
        return this.getQuery();
    }

    @Override
    public int getColumnIndex(FieldDescriptor fieldDescriptor) {
        int n = Integer.MIN_VALUE;
        FieldDescriptor[] fieldDescriptorArray = this.getFieldsForSelect();
        if (fieldDescriptorArray != null) {
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                if (!fieldDescriptorArray[i].equals(fieldDescriptor)) continue;
                n = i + 1;
                break;
            }
        }
        return n;
    }
}

