/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import org.apache.ojb.broker.platforms.BlobWrapper;
import org.apache.ojb.broker.platforms.ClobWrapper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class Oracle9iLobHandler {
    protected static Logger logger = LoggerFactory.getLogger(Oracle9iLobHandler.class);

    private static ClobWrapper createTempCLOB(Connection connection, ClobWrapper clobWrapper) {
        if (clobWrapper == null) {
            return null;
        }
        ClobWrapper clobWrapper2 = null;
        try {
            int n;
            clobWrapper2 = ClobWrapper.createTemporary(connection, true, ClobWrapper.getDurationSessionValue());
            clobWrapper.open(ClobWrapper.getModeReadOnlyValue());
            clobWrapper2.open(ClobWrapper.getModeReadWriteValue());
            Reader reader = clobWrapper.getCharacterStream();
            Writer writer = clobWrapper2.getCharacterOutputStream();
            char[] cArray = new char[clobWrapper.getBufferSize()];
            while ((n = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n);
            }
            writer.flush();
            writer.close();
            reader.close();
            clobWrapper.close();
            clobWrapper2.close();
        }
        catch (Exception exception) {
            logger.error("Error during temporary CLOB write", exception);
            Oracle9iLobHandler.freeTempLOB(clobWrapper2, null);
        }
        return clobWrapper2;
    }

    public static String convertCLOBtoString(Connection connection, Object object) {
        ClobWrapper clobWrapper = new ClobWrapper();
        clobWrapper.setClob(object);
        ClobWrapper clobWrapper2 = Oracle9iLobHandler.createTempCLOB(connection, clobWrapper);
        if (clobWrapper2 == null) {
            return null;
        }
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            clobWrapper2.open(ClobWrapper.getModeReadOnlyValue());
            Reader reader = clobWrapper2.getCharacterStream();
            char[] cArray = new char[clobWrapper2.getBufferSize()];
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            reader.close();
            clobWrapper2.close();
            string = stringBuffer.toString();
            stringBuffer = null;
        }
        catch (Exception exception) {
            logger.error("Error during CLOB read", exception);
            Oracle9iLobHandler.freeTempLOB(clobWrapper2, null);
        }
        return string;
    }

    public static Object createCLOBFromString(Connection connection, String string) {
        if (string == null) {
            return null;
        }
        ClobWrapper clobWrapper = null;
        try {
            clobWrapper = ClobWrapper.createTemporary(connection, true, ClobWrapper.getDurationSessionValue());
            if (clobWrapper != null) {
                clobWrapper.open(ClobWrapper.getModeReadWriteValue());
                clobWrapper.trim(0L);
                Writer writer = clobWrapper.getCharacterOutputStream();
                if (writer != null) {
                    writer.write(string);
                    writer.flush();
                    writer.close();
                }
                clobWrapper.close();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Oracle9iLobHandler.freeTempLOB(clobWrapper, null);
            if (throwable instanceof UnsatisfiedLinkError) {
                logger.error("Oracle JDBC-driver version does not match installed OCI-driver");
            } else {
                logger.error("Error during temporary CLOB write", throwable);
            }
        }
        catch (Exception exception) {
            logger.error("Error during temporary CLOB write", exception);
            Oracle9iLobHandler.freeTempLOB(clobWrapper, null);
        }
        return clobWrapper == null ? null : clobWrapper.getClob();
    }

    private static BlobWrapper createTempBLOB(Connection connection, BlobWrapper blobWrapper) {
        if (blobWrapper == null) {
            return null;
        }
        BlobWrapper blobWrapper2 = null;
        try {
            int n;
            blobWrapper2 = BlobWrapper.createTemporary(connection, true, BlobWrapper.getDurationSessionValue());
            blobWrapper.open(BlobWrapper.getModeReadOnlyValue());
            blobWrapper2.open(BlobWrapper.getModeReadWriteValue());
            InputStream inputStream = blobWrapper.getBinaryStream();
            OutputStream outputStream = blobWrapper2.getBinaryOutputStream();
            byte[] byArray = new byte[blobWrapper.getBufferSize()];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            outputStream.close();
            inputStream.close();
            blobWrapper.close();
            blobWrapper2.close();
        }
        catch (Exception exception) {
            logger.error("Error during temporary BLOB write", exception);
            Oracle9iLobHandler.freeTempLOB(null, blobWrapper2);
        }
        return blobWrapper2;
    }

    public static byte[] convertBLOBtoByteArray(Connection connection, Object object) {
        BlobWrapper blobWrapper = new BlobWrapper();
        blobWrapper.setBlob(object);
        BlobWrapper blobWrapper2 = Oracle9iLobHandler.createTempBLOB(connection, blobWrapper);
        if (blobWrapper2 == null) {
            return null;
        }
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        try {
            blobWrapper2.open(BlobWrapper.getModeReadOnlyValue());
            InputStream inputStream = blobWrapper2.getBinaryStream();
            byte[] byArray2 = new byte[blobWrapper2.getBufferSize()];
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inputStream.close();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            blobWrapper2.close();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
        }
        catch (Exception exception) {
            logger.error("Error during BLOB read", exception);
            Oracle9iLobHandler.freeTempLOB(null, blobWrapper2);
        }
        return byArray;
    }

    public static Object createBLOBFromByteArray(Connection connection, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        BlobWrapper blobWrapper = null;
        try {
            blobWrapper = BlobWrapper.createTemporary(connection, true, BlobWrapper.getDurationSessionValue());
            blobWrapper.open(BlobWrapper.getModeReadWriteValue());
            blobWrapper.trim(0L);
            OutputStream outputStream = blobWrapper.getBinaryOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            blobWrapper.close();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Oracle9iLobHandler.freeTempLOB(null, blobWrapper);
            if (throwable instanceof UnsatisfiedLinkError) {
                logger.error("Oracle JDBC-driver version does not match installed OCI-driver");
            } else {
                logger.error("Error during temporary BLOB write", throwable);
            }
        }
        catch (Exception exception) {
            logger.error("Error during temporary BLOB write", exception);
            Oracle9iLobHandler.freeTempLOB(null, blobWrapper);
        }
        return blobWrapper == null ? null : blobWrapper.getBlob();
    }

    private static void freeTempLOB(ClobWrapper clobWrapper, BlobWrapper blobWrapper) {
        try {
            if (clobWrapper != null) {
                if (clobWrapper.isOpen()) {
                    clobWrapper.close();
                }
                clobWrapper.freeTemporary();
            }
            if (blobWrapper != null) {
                if (blobWrapper.isOpen()) {
                    blobWrapper.close();
                }
                blobWrapper.freeTemporary();
            }
        }
        catch (Exception exception) {
            logger.error("Error during temporary LOB release", exception);
        }
    }
}

