/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.annotation.Annotation;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;

public class MonitoredSpringControllerAndServicePointcut
implements Pointcut {
    public ClassFilter getClassFilter() {
        return MonitoredClassFilter.INSTANCE;
    }

    public MethodMatcher getMethodMatcher() {
        return MethodMatcher.TRUE;
    }

    private static enum MonitoredClassFilter implements ClassFilter
    {
        INSTANCE;

        private static final Class<? extends Annotation> CONTROLLER_CLASS;
        private static final Class<? extends Annotation> REST_CONTROLLER_CLASS;
        private static final Class<? extends Annotation> SERVICE_CLASS;

        private static <T> Class<T> getClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public boolean matches(Class<?> clazz) {
            return CONTROLLER_CLASS != null && clazz.isAnnotationPresent(CONTROLLER_CLASS) || REST_CONTROLLER_CLASS != null && clazz.isAnnotationPresent(REST_CONTROLLER_CLASS) || SERVICE_CLASS != null && clazz.isAnnotationPresent(SERVICE_CLASS);
        }

        static {
            CONTROLLER_CLASS = MonitoredClassFilter.getClass("org.springframework.stereotype.Controller");
            REST_CONTROLLER_CLASS = MonitoredClassFilter.getClass("org.springframework.web.bind.annotation.RestController");
            SERVICE_CLASS = MonitoredClassFilter.getClass("org.springframework.stereotype.Service");
        }
    }
}

