/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.style;

import java.io.Reader;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.coreservice.impl.style.StyleBo;
import org.kuali.rice.coreservice.impl.style.StyleExportDataSet;

public class StyleXmlExporter
implements XmlExporter {
    private static final Logger LOG = LogManager.getLogger(StyleXmlExporter.class);
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.STYLE_NAMESPACE);

    public boolean supportPrettyPrint() {
        return false;
    }

    public Element export(ExportDataSet exportDataSet) {
        StyleExportDataSet dataSet = StyleExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getStyles().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "styles");
            rootElement.setAttribute("schemaLocation", "ns:workflow/Style resource:Style", XmlConstants.SCHEMA_NAMESPACE);
            for (StyleBo edocLite : dataSet.getStyles()) {
                this.exportStyle(rootElement, edocLite);
            }
            return rootElement;
        }
        return null;
    }

    private void exportStyle(Element parentEl, StyleBo style) {
        if (style == null) {
            LOG.error("Attempted to export style which was not found");
            return;
        }
        Element styleWrapperEl = this.renderer.renderElement(parentEl, "style");
        this.renderer.renderAttribute(styleWrapperEl, "name", style.getName());
        try {
            Element styleEl = XmlHelper.buildJDocument((Reader)new StringReader(style.getXmlContent())).getRootElement();
            styleWrapperEl.addContent((Content)styleEl.detach());
        }
        catch (XmlException e) {
            throw new RuntimeException("Error building JDom document for style", e);
        }
    }
}

