/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.engine.BlanketApproveEngine;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.StandardWorkflowEngine;
import org.kuali.rice.kew.engine.WorkflowEngine;
import org.kuali.rice.kew.engine.WorkflowEngineFactory;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.engine.simulation.SimulationEngine;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.springframework.beans.factory.InitializingBean;

public class WorkflowEngineFactoryImpl
implements WorkflowEngineFactory,
InitializingBean {
    private RouteNodeService routeNodeService;
    private RouteHeaderService routeHeaderService;
    private ParameterService parameterService;

    public void afterPropertiesSet() {
        if (this.routeNodeService == null) {
            throw new IllegalStateException("routeNodeService not properly injected, was null.");
        }
        if (this.routeHeaderService == null) {
            throw new IllegalStateException("routeHeaderService not properly injected, was null.");
        }
    }

    @Override
    public <E extends WorkflowEngine> E newEngine(OrchestrationConfig config) {
        switch (config.getCapability()) {
            case STANDARD: {
                return (E)new StandardWorkflowEngine(this.routeNodeService, this.routeHeaderService, this.parameterService, config);
            }
            case BLANKET_APPROVAL: {
                return (E)new BlanketApproveEngine(this.routeNodeService, this.routeHeaderService, this.parameterService, config);
            }
            case SIMULATION: {
                return (E)new SimulationEngine(this.routeNodeService, this.routeHeaderService, this.parameterService, config);
            }
        }
        return null;
    }

    public RouteNodeService getRouteNodeService() {
        return this.routeNodeService;
    }

    public void setRouteNodeService(RouteNodeService routeNodeService) {
        this.routeNodeService = routeNodeService;
    }

    public RouteHeaderService getRouteHeaderService() {
        return this.routeHeaderService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

