/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail;

import com.thoughtworks.xstream.XStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.core.api.mail.EmailFrom;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.core.api.mail.EmailTo;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.SimpleNode;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.mail.EmailStyleHelper;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EmailNode
implements SimpleNode {
    private static final Logger LOG = LogManager.getLogger(EmailNode.class);
    private EmailStyleHelper emailStyleHelper = new EmailStyleHelper();
    private String styleName;
    private String from;
    private String to;

    @Override
    public SimpleResult process(RouteContext context, RouteHelper helper) throws Exception {
        if (context.isSimulation() && !context.getActivationContext().isActivateRequests()) {
            return new SimpleResult(true);
        }
        this.loadConfiguration(context);
        org.w3c.dom.Document document = this.generateXmlInput(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("XML input for email tranformation:\n" + XmlJotter.jotNode((Node)document));
        }
        Templates style = this.loadStyleSheet(this.styleName);
        EmailContent emailContent = this.emailStyleHelper.generateEmailContent(style, document);
        if (!StringUtils.isBlank((String)this.to)) {
            CoreApiServiceLocator.getMailer().sendEmail(new EmailFrom(this.from), new EmailTo(this.to), new EmailSubject(emailContent.getSubject()), new EmailBody(emailContent.getBody()), emailContent.isHtml());
        }
        return new SimpleResult(true);
    }

    protected org.w3c.dom.Document generateXmlInput(RouteContext context) throws Exception {
        DocumentBuilder db = this.getDocumentBuilder(true);
        org.w3c.dom.Document doc = db.newDocument();
        Element emailNodeElem = doc.createElement("emailNode");
        doc.appendChild(emailNodeElem);
        Object principalId = null;
        Document routeHeaderVO = DocumentRouteHeaderValue.to(context.getDocument());
        RouteNodeInstance routeNodeInstanceVO = org.kuali.rice.kew.engine.node.RouteNodeInstance.to(context.getNodeInstance());
        org.w3c.dom.Document documentContent = context.getDocumentContent().getDocument();
        XStream xstream = new XStream();
        Element docElem = XmlHelper.readXml((String)xstream.toXML((Object)routeHeaderVO)).getDocumentElement();
        Element nodeElem = XmlHelper.readXml((String)xstream.toXML((Object)routeNodeInstanceVO)).getDocumentElement();
        emailNodeElem.appendChild(doc.importNode(docElem, true));
        emailNodeElem.appendChild(doc.importNode(nodeElem, true));
        emailNodeElem.appendChild(doc.importNode(documentContent.getDocumentElement(), true));
        Element dConElem = context.getDocumentContent().getApplicationContent();
        emailNodeElem.appendChild(doc.importNode(dConElem, true));
        return doc;
    }

    protected DocumentBuilder getDocumentBuilder(boolean coalesce) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setCoalescing(coalesce);
        return dbf.newDocumentBuilder();
    }

    protected Templates loadStyleSheet(String styleName) {
        try {
            Templates style = CoreServiceApiServiceLocator.getStyleService().getStyleAsTranslet(styleName);
            if (style == null) {
                throw new WorkflowRuntimeException("Failed to locate stylesheet with name '" + styleName + "'");
            }
            return style;
        }
        catch (TransformerConfigurationException tce) {
            throw new WorkflowRuntimeException("Failed to load stylesheet with name '" + styleName + "'", (Throwable)tce);
        }
    }

    protected boolean isProduction() {
        return ConfigContext.getCurrentContextConfig().isProductionEnvironment();
    }

    protected void loadConfiguration(RouteContext context) throws Exception {
        NodeList styleNames;
        String contentFragment = context.getNodeInstance().getRouteNode().getContentFragment();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        org.w3c.dom.Document document = db.parse(new InputSource(new StringReader(contentFragment)));
        if (!this.isProduction()) {
            NodeList testAddresses = document.getElementsByTagName("testAddress");
            if (testAddresses.getLength() >= 1) {
                this.to = testAddresses.item(0).getTextContent();
            }
        } else {
            NodeList toAddresses = document.getElementsByTagName("to");
            if (toAddresses.getLength() != 1) {
                throw new WorkflowRuntimeException("Must have exactly one 'to' address");
            }
            this.to = toAddresses.item(0).getTextContent();
            if ("initiator".equalsIgnoreCase(this.to)) {
                Person person = KimApiServiceLocator.getPersonService().getPerson(context.getDocument().getInitiatorWorkflowId());
                String string = this.to = person == null ? "" : person.getEmailAddressUnmasked();
            }
            if (StringUtils.isBlank((String)this.to)) {
                throw new WorkflowRuntimeException("Email Address is missing from user's profile.");
            }
        }
        NodeList fromAddresses = document.getElementsByTagName("from");
        if (fromAddresses.getLength() != 1) {
            throw new WorkflowRuntimeException("Must have exactly one 'from' address");
        }
        this.from = fromAddresses.item(0).getTextContent();
        if ("initiator".equalsIgnoreCase(this.from)) {
            Person initiator = KEWServiceLocator.getIdentityHelperService().getPerson(context.getDocument().getInitiatorWorkflowId());
            this.from = "\"" + initiator.getName() + "\" <";
            this.from = this.from + initiator.getEmailAddress() + ">";
        }
        if (StringUtils.isBlank((String)this.from)) {
            throw new WorkflowRuntimeException("No email address could be found found for principal with id " + context.getDocument().getInitiatorWorkflowId());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Email From is set to:" + this.from);
            LOG.info("Email To is set to:" + this.to);
        }
        if ((styleNames = document.getElementsByTagName("style")).getLength() != 1) {
            throw new WorkflowRuntimeException("Must have exactly one 'style'");
        }
        this.styleName = styleNames.item(0).getTextContent();
    }
}

