/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleExpression;
import org.kuali.rice.kew.rule.RuleExpressionResult;
import org.kuali.rice.kew.rule.RuleImpl;

public class BSFRuleExpression
implements RuleExpression {
    private static final Logger LOG = LogManager.getLogger(BSFRuleExpression.class);

    @Override
    public RuleExpressionResult evaluate(Rule rule, RouteContext context) {
        RuleExpressionResult result;
        RuleContract ruleDefinition = rule.getDefinition();
        String name = ruleDefinition.getName();
        String type = ruleDefinition.getRuleExpressionDef().getType();
        String lang = this.parseLang(type, "groovy");
        String expression = ruleDefinition.getRuleExpressionDef().getExpression();
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName(lang);
        try {
            this.declareBeans(engine, rule, context);
            result = (RuleExpressionResult)engine.eval(expression);
        }
        catch (ScriptException e) {
            String details = e.getLineNumber() >= 0 ? " line: " + e.getLineNumber() + " column: " + e.getColumnNumber() : "";
            LOG.debug("Error evaluating rule '" + name + "' " + type + " expression" + details + ": '" + expression + "'" + details, (Throwable)e);
            throw new RiceIllegalStateException("Error evaluating rule '" + name + "' " + type + " expression" + details, (Throwable)e);
        }
        if (result == null) {
            return new RuleExpressionResult(rule, false);
        }
        return result;
    }

    protected String parseLang(String type, String deflt) {
        int colon = type.indexOf(58);
        if (colon > -1) {
            return type.substring(colon + 1);
        }
        return deflt;
    }

    protected void declareBeans(ScriptEngine engine, Rule rule, RouteContext context) throws ScriptException {
        engine.put("rule", rule);
        engine.put("routeContext", context);
        engine.put("workflow", new WorkflowRuleAPI(context));
    }

    protected static final class WorkflowRuleAPI {
        private final RouteContext context;

        WorkflowRuleAPI(RouteContext context) {
            this.context = context;
        }

        public RuleExpressionResult invokeRule(String name) throws WorkflowException {
            org.kuali.rice.kew.api.rule.Rule rbv = KewApiServiceLocator.getRuleService().getRuleByName(name);
            if (rbv == null) {
                throw new WorkflowRuntimeException("Could not find rule named \"" + name + "\"");
            }
            RuleImpl r = new RuleImpl(rbv);
            return r.evaluate(r, this.context);
        }
    }
}

