/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.rule.AbstractIdRoleAttribute;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kew.workgroup.GroupNameId;

public class WorkgroupRoleAttribute
extends AbstractIdRoleAttribute {
    private static final long serialVersionUID = 5562142284908152678L;
    private static final String WORKGROUP_ROLE_NAME = "workgroupName";
    private static final String ATTRIBUTE_ELEMENT = "WorkgroupRoleAttribute";
    private static final String WORKGROUP_ELEMENT = "workgroupName";

    @Override
    public List<RoleName> getRoleNames() {
        ArrayList<RoleName> roleNames = new ArrayList<RoleName>();
        roleNames.add(new RoleName(this.getClass().getName(), "workgroupName", "Workgroup Name"));
        return roleNames;
    }

    @Override
    protected String getAttributeElementName() {
        return ATTRIBUTE_ELEMENT;
    }

    @Override
    protected Id resolveId(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        String groupName = Utilities.parseGroupName(id);
        String namespace = Utilities.parseGroupNamespaceCode(id);
        return new GroupNameId(namespace, groupName);
    }

    @Override
    protected String getIdName() {
        return "workgroupName";
    }

    public String getWorkgroupName() {
        return this.getIdValue();
    }

    public void setWorkgroupName(String workgroupName) {
        this.setIdValue(workgroupName);
    }
}

