/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimAttributeFieldContract;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kns.kim.role.RoleTypeServiceBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="unitHierarchyRoleTypeService")
public class UnitHierarchyRoleTypeServiceImpl
extends RoleTypeServiceBase {
    public static final String DESCENDS_HIERARCHY_N = "N";
    public static final String DESCENDS_HIERARCHY_Y = "Y";
    public static final String DESCENDS_HIERARCHY_YES = "Yes";
    public static final String UNIT_NUMBER_WILDCARD = "*";
    private static final String KIM_UI_CHECKBOX_DEFAULT_VALUE = "no";
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService kualiConfigurationService;

    public boolean performMatch(Map<String, String> qualification, Map<String, String> roleQualifier) {
        if (this.roleQualifiedByUnitHierarchy(roleQualifier) && qualification.containsKey("unitNumber")) {
            return this.performWildCardMatching(qualification, roleQualifier) || this.unitQualifierMatches(qualification, roleQualifier) || this.unitQualifierMatchesHierarchy(qualification, roleQualifier);
        }
        return false;
    }

    protected List<RemotableAttributeError> validateDataDictionaryAttribute(KimTypeAttribute attr, String key, String value) {
        if (StringUtils.equalsIgnoreCase((CharSequence)attr.getKimAttribute().getAttributeName(), (CharSequence)"subunits") && StringUtils.isBlank((CharSequence)value)) {
            return super.validateDataDictionaryAttribute(attr, key, KIM_UI_CHECKBOX_DEFAULT_VALUE);
        }
        return super.validateDataDictionaryAttribute(attr, key, value);
    }

    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        List<Object> validationErrors = new ArrayList<RemotableAttributeError>();
        if (this.roleQualifiedByUnitHierarchy(attributes) && attributes.containsKey("unitNumber")) {
            validationErrors = super.validateAttributes(kimTypeId, attributes);
        }
        return validationErrors;
    }

    protected boolean roleQualifiedByUnitHierarchy(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("unitNumber") && roleQualifier.containsKey("subunits");
    }

    protected boolean unitQualifierMatches(Map<String, String> qualification, Map<String, String> roleQualifier) {
        return StringUtils.equals((CharSequence)qualification.get("unitNumber"), (CharSequence)roleQualifier.get("unitNumber"));
    }

    protected boolean unitQualifierMatchesHierarchy(Map<String, String> qualification, Map<String, String> roleQualifier) {
        String parentUnitNumber;
        Unit unit;
        boolean qualifierMatches = false;
        String unitNumber = qualification.get("unitNumber");
        while (!qualifierMatches && (unit = this.unitService.getUnit(unitNumber)) != null && (parentUnitNumber = unit.getParentUnitNumber()) != null) {
            qualifierMatches = StringUtils.equals((CharSequence)parentUnitNumber, (CharSequence)roleQualifier.get("unitNumber")) && this.descendsSubunits(roleQualifier);
            unitNumber = parentUnitNumber;
        }
        return qualifierMatches;
    }

    protected boolean descendsSubunits(Map<String, String> roleQualifier) {
        return StringUtils.equalsIgnoreCase((CharSequence)DESCENDS_HIERARCHY_Y, (CharSequence)roleQualifier.get("subunits")) || StringUtils.equalsIgnoreCase((CharSequence)DESCENDS_HIERARCHY_YES, (CharSequence)roleQualifier.get("subunits"));
    }

    protected boolean performWildCardMatching(Map<String, String> qualification, Map<String, String> roleQualifier) {
        String unitNumber = qualification.get("unitNumber");
        return UNIT_NUMBER_WILDCARD.equalsIgnoreCase(unitNumber);
    }

    public List<String> getUniqueAttributes(String kimTypeId) {
        return new ArrayList<String>();
    }

    public List<KimAttributeField> getAttributeDefinitions(String kimTypeId) {
        if (StringUtils.isBlank((CharSequence)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        ArrayList<KimAttributeField> attributeList = new ArrayList<KimAttributeField>(super.getAttributeDefinitions(kimTypeId));
        for (int i = 0; i < attributeList.size(); ++i) {
            KimAttributeField definition = (KimAttributeField)attributeList.get(i);
            if (!"unitNumber".equals(definition.getAttributeField().getName())) continue;
            KimAttributeField.Builder b = KimAttributeField.Builder.create((KimAttributeFieldContract)definition);
            String baseUrl = this.getKualiConfigurationService().getPropertyValueAsString("application.lookup.url");
            ArrayList<Object> widgetsCopy = new ArrayList<Object>();
            for (RemotableAbstractWidget.Builder widget : b.getAttributeField().getWidgets()) {
                if (widget instanceof RemotableQuickFinder.Builder) {
                    RemotableQuickFinder.Builder orig = (RemotableQuickFinder.Builder)widget;
                    RemotableQuickFinder.Builder copy = RemotableQuickFinder.Builder.create((String)baseUrl, (String)orig.getDataObjectClass());
                    copy.setLookupParameters(orig.getLookupParameters());
                    copy.setFieldConversions(orig.getFieldConversions());
                    widgetsCopy.add(copy);
                    continue;
                }
                widgetsCopy.add(widget);
            }
            b.getAttributeField().setWidgets(widgetsCopy);
            attributeList.set(i, b.build());
        }
        return Collections.unmodifiableList(attributeList);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

