/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchAwardSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchInstitutionalProposalSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchSubAwardSerializer;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.bo.NegotiationsGroupingBase;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.krad.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ElasticsearchNegotiationSerializer
extends ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="esAwardSerializer")
    private ElasticsearchAwardSerializer awardSerializer;
    @Autowired
    @Qualifier(value="esInstitutionalProposalSerializer")
    private ElasticsearchInstitutionalProposalSerializer institutionalProposalSerializer;
    @Autowired
    @Qualifier(value="esSubAwardSerializer")
    private ElasticsearchSubAwardSerializer subAwardSerializer;
    @Autowired
    @Qualifier(value="negotiationService")
    private NegotiationService negotiationService;

    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        NegotiationDocument document = (NegotiationDocument)doc;
        Negotiation negotiation = document.getNegotiation();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, (Document)document);
        esDoc.setPrimaryKey(String.valueOf(negotiation.getNegotiationId()));
        esDoc.setNegotiationId(String.valueOf(negotiation.getNegotiationId()));
        esDoc.setSequenceNumber(0);
        esDoc.setSequenceStatus(VersionStatus.ACTIVE.name());
        esDoc.setStatusCode(String.valueOf(negotiation.getNegotiationStatusId()));
        esDoc.setStatusDescription(negotiation.getNegotiationStatus().getDescription());
        esDoc.setStartDate(negotiation.getNegotiationStartDate());
        esDoc.setEndDate(negotiation.getNegotiationEndDate());
        if (negotiation.getNegotiationAgreementType() != null) {
            esDoc.setAgreementType(negotiation.getNegotiationAgreementType().getDescription());
        }
        esDoc.setActivityLocations(negotiation.getActivities().stream().map(NegotiationActivity::getLocation).filter(Objects::nonNull).map(NegotiationsGroupingBase::getDescription).filter(Objects::nonNull).collect(Collectors.toSet()));
        esDoc.setActivityTypes(negotiation.getActivities().stream().map(NegotiationActivity::getActivityType).filter(Objects::nonNull).map(NegotiationsGroupingBase::getDescription).filter(Objects::nonNull).collect(Collectors.toSet()));
        esDoc.setActivityFollowupDates(negotiation.getActivities().stream().map(NegotiationActivity::getFollowupDate).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (negotiation.getNegotiationAssociationType() != null) {
            String associationType = negotiation.getNegotiationAssociationType().getCode();
            esDoc.setAssociationType(negotiation.getNegotiationAssociationType().getDescription());
            esDoc.setTypeCode(associationType);
            esDoc.setTypeDescription(negotiation.getNegotiationAssociationType().getDescription());
            this.setAssociatedInfo(esDoc, negotiation);
        }
        if (negotiation.getNegotiator() != null) {
            esDoc.setNegotiatorId(negotiation.getNegotiatorPersonId());
            esDoc.setNegotiatorName(negotiation.getNegotiatorName());
            esDoc.addAdministratorName(negotiation.getNegotiatorName());
        }
        return esDoc;
    }

    private void setAssociatedInfo(GrantsSearchDocument esDoc, Negotiation negotiation) {
        Negotiable associatedDocument = this.negotiationService.getAssociatedObject(negotiation);
        if (associatedDocument != null) {
            if (associatedDocument instanceof InstitutionalProposal) {
                this.institutionalProposalSerializer.setCommonFields(esDoc, (InstitutionalProposal)associatedDocument);
            } else if (associatedDocument instanceof ProposalLog) {
                this.setProposalLogAssociatedInfo(esDoc, (ProposalLog)associatedDocument);
            } else if (associatedDocument instanceof Award) {
                this.awardSerializer.setCommonFields(esDoc, (Award)associatedDocument);
            } else if (associatedDocument instanceof SubAward) {
                this.subAwardSerializer.setCommonFields(esDoc, (SubAward)associatedDocument);
            } else if (associatedDocument instanceof NegotiationUnassociatedDetail) {
                this.setUnassociatedInfo(esDoc, (NegotiationUnassociatedDetail)associatedDocument);
            } else {
                throw new IllegalArgumentException(String.format("Document %s of type %s is not a supported Negotiable for serialization", esDoc.getDocumentNumber(), associatedDocument.getClass().getSimpleName()));
            }
        }
    }

    private void setProposalLogAssociatedInfo(GrantsSearchDocument esDoc, ProposalLog proposalLog) {
        if (proposalLog != null) {
            esDoc.addProposalNumber(proposalLog.getProposalNumber());
            esDoc.setPrincipalInvestigatorName(proposalLog.getPiName());
            esDoc.setPersonnelNames(Set.of(proposalLog.getPiName()));
            if (StringUtils.isNotBlank((CharSequence)proposalLog.getPiId())) {
                esDoc.addPersonnelId(proposalLog.getPiId());
            } else if (proposalLog.getRolodexId() != null) {
                esDoc.addPersonnelId(String.valueOf(proposalLog.getRolodexId()));
            }
            esDoc.setTitle(proposalLog.getTitle());
            esDoc.setSponsorCode(proposalLog.getSponsorCode());
            esDoc.setSponsorName(proposalLog.getSponsorName());
            esDoc.setPrimeSponsorCode(proposalLog.getPrimeSponsorCode());
            esDoc.setPrimeSponsorName(proposalLog.getPrimeSponsorName());
            esDoc.setLeadUnitNumber(proposalLog.getLeadUnitNumber());
            esDoc.setLeadUnitName(proposalLog.getLeadUnitName());
        }
    }

    private void setUnassociatedInfo(GrantsSearchDocument esDoc, NegotiationUnassociatedDetail unassociatedDetail) {
        esDoc.setTitle(unassociatedDetail.getTitle());
        esDoc.setSponsorCode(unassociatedDetail.getSponsorCode());
        esDoc.setSponsorName(unassociatedDetail.getSponsorName());
        esDoc.setPrimeSponsorCode(unassociatedDetail.getPrimeSponsorCode());
        esDoc.setPrimeSponsorName(unassociatedDetail.getPrimeSponsorName());
        esDoc.setLeadUnitNumber(unassociatedDetail.getLeadUnitNumber());
        esDoc.setLeadUnitName(unassociatedDetail.getLeadUnitName());
        if (unassociatedDetail.getPIEmployee() != null) {
            esDoc.setPrincipalInvestigatorName(unassociatedDetail.getPiEmployeeName());
            esDoc.addPersonnelName(unassociatedDetail.getPiEmployeeName());
            esDoc.addPersonnelId(unassociatedDetail.getPiPersonId());
        } else if (unassociatedDetail.getPINonEmployee() != null) {
            esDoc.setPrincipalInvestigatorName(unassociatedDetail.getPiNonEmployeeName());
            esDoc.addPersonnelName(unassociatedDetail.getPiNonEmployeeName());
            esDoc.addPersonnelId(unassociatedDetail.getPiRolodexId());
        }
        if (unassociatedDetail.getContactAdmin() != null) {
            esDoc.addAdministratorName(unassociatedDetail.getContactAdmin().getFullName());
        }
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("VIEW NEGOTIATION");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof NegotiationDocument;
    }
}

