/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchAwardSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.krad.document.Document;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;

@Configurable(autowire=Autowire.BY_TYPE)
public class ElasticsearchSubAwardSerializer
extends ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="esAwardSerializer")
    private ElasticsearchAwardSerializer awardSerializer;
    @Autowired
    @Qualifier(value="awardVersionService")
    private AwardVersionService awardVersionService;

    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        SubAwardDocument document = (SubAwardDocument)doc;
        SubAward subAward = document.getSubAward();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, (Document)document);
        esDoc.setPrimaryKey(String.valueOf(subAward.getSubAwardId()));
        esDoc.setAccountId(subAward.getAccountNumber());
        esDoc.setSequenceNumber(subAward.getSequenceNumber());
        esDoc.setSequenceStatus(subAward.getSubAwardSequenceStatus());
        esDoc.setTypeCode(String.valueOf(subAward.getSubAwardTypeCode()));
        esDoc.setTypeDescription(String.valueOf(subAward.getSubAwardType().getDescription()));
        esDoc.setStatusCode(String.valueOf(subAward.getStatusCode()));
        esDoc.setStatusDescription(subAward.getStatusDescription());
        esDoc.setStartDate(subAward.getStartDate());
        esDoc.setEndDate(subAward.getEndDate());
        if (subAward.getExecutionDate() != null) {
            esDoc.addExecutionDate(subAward.getExecutionDate());
        }
        esDoc.setRequisitionerName(subAward.getRequisitionerName());
        this.getRolodex(subAward.getSiteInvestigatorId()).map(Rolodex::getFullName).ifPresent(esDoc::setSiteInvestigatorName);
        esDoc.addSubrecipientOrganizationName(subAward.getSubAwardOrganizationName());
        esDoc.setPoNumber(subAward.getPurchaseOrderNum());
        this.setCommonFields(esDoc, subAward);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, SubAward subAward) {
        esDoc.setSubawardNumber(subAward.getSubAwardCode());
        esDoc.setTitle(subAward.getTitle());
        esDoc.setSponsorCode(subAward.getSponsorCode());
        esDoc.setSponsorName(subAward.getSponsorName());
        esDoc.setPrimeSponsorCode(subAward.getPrimeSponsorCode());
        esDoc.setPrimeSponsorName(subAward.getPrimeSponsorName());
        esDoc.setLeadUnitNumber(subAward.getLeadUnitNumber());
        esDoc.setLeadUnitName(subAward.getLeadUnitName());
        this.setSubAwardPersonFields(esDoc, subAward);
        this.getAwardForSubAward(subAward).ifPresent(linkedAward -> {
            esDoc.setAwardNumber(linkedAward.getAwardNumber());
            esDoc.setSponsorNumber(linkedAward.getSponsorAwardNumber());
            this.awardSerializer.setAwardPersonFields(esDoc, (Award)linkedAward);
        });
    }

    protected void setSubAwardPersonFields(GrantsSearchDocument esDoc, SubAward subAward) {
        esDoc.setPrincipalInvestigatorName(subAward.getSiteInvestigatorName());
        esDoc.setAdministratorNames(Stream.concat(subAward.getSubAwardContactsList().stream().map(SubAwardContact::getRolodexName), Stream.of(subAward.getRequisitionerName())).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    protected Optional<Award> getAwardForSubAward(SubAward subAward) {
        if (subAward.getSubAwardFundingSourceList() != null && subAward.getSubAwardFundingSourceList().size() > 0) {
            return subAward.getSubAwardFundingSourceList().stream().max(Comparator.comparing(KcPersistableBusinessObjectBase::getUpdateTimestamp)).map(SubAwardFundingSource::getAward).map(award -> {
                Award workingAward = this.awardVersionService.getWorkingAwardVersion(award.getAwardNumber());
                return workingAward != null ? workingAward : award;
            });
        }
        return Optional.empty();
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("VIEW SUBAWARD");
    }

    @Override
    public boolean supports(Object document) {
        if (document instanceof SubAwardDocument) {
            SubAward subAward = ((SubAwardDocument)document).getSubAward();
            return VersionStatus.ACTIVE.name().equals(subAward.getSubAwardSequenceStatus()) || VersionStatus.PENDING.name().equals(subAward.getSubAwardSequenceStatus());
        }
        return false;
    }
}

