/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.dd;

import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.dd.DataDictionaryOverride;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.impl.dd.DataDictionaryOverrideUtils;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.springframework.beans.BeansException;

public class DataDictionaryOverrideMaintenanceDocumentRules
extends KcMaintenanceDocumentRuleBase {
    private static final String ERROR_KEY_SPRING_OVERIDE = "error.spring.overide.not.valid";
    private static final String ERROR_KEY_INVALID_FILE = "error.invalid.data.dictionary.override.invalid.fileName";
    private static final String ERROR_PROPERTY = "document.newMaintainableObject.overrideBeansFile";
    private static final String UNKNOWN_ERROR = "Unknown Error";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = this.isFileValid(document);
        DataDictionaryOverride override = (DataDictionaryOverride)document.getDocumentBusinessObject();
        try {
            if (!"Delete".equals(document.getNewMaintainableObject().getMaintenanceAction()) && override.isActive()) {
                byte[] overrideFile;
                byte[] byArray = overrideFile = override.getOverrideBeansFile() != null ? override.getOverrideBeansFile().getFileData() : override.getAttachmentContent();
                if (overrideFile != null) {
                    DataDictionaryOverrideUtils.createNewWithOverride(this.getDataDictionaryService().getDataDictionary(), override.getId() != null ? override.getId() : UUID.randomUUID().toString(), overrideFile);
                }
            } else if ("Delete".equals(document.getNewMaintainableObject().getMaintenanceAction())) {
                DataDictionaryOverrideUtils.createNewRemovingOverride(this.getDataDictionaryService().getDataDictionary(), override.getId() != null ? override.getId() : UUID.randomUUID().toString());
            }
        }
        catch (IOException | DataDictionaryException | BeansException e) {
            String msg = e.getMessage();
            this.getGlobalVariableService().getMessageMap().putError(ERROR_PROPERTY, ERROR_KEY_SPRING_OVERIDE, new String[]{StringUtils.isNotBlank((CharSequence)msg) ? msg : UNKNOWN_ERROR});
            valid = false;
        }
        return valid;
    }

    protected boolean isFileValid(MaintenanceDocument document) {
        DataDictionaryOverride override = (DataDictionaryOverride)document.getNewMaintainableObject().getDataObject();
        if (override.getOverrideBeansFile() == null && override.getFileName() == null) {
            this.getGlobalVariableService().getMessageMap().putError(ERROR_PROPERTY, ERROR_KEY_INVALID_FILE, new String[0]);
            return false;
        }
        return true;
    }
}

