/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class AwardAmountInfoServiceImpl
implements AwardAmountInfoService {
    transient BusinessObjectService businessObjectService;
    transient DocumentService documentService;

    @Override
    public AwardAmountInfo fetchLastAwardAmountInfoForAwardVersionAndFinalizedTandMDocumentNumber(Award award) {
        ArrayList<AwardAmountInfo> awardAmountInfos = new ArrayList<AwardAmountInfo>(award.getAwardAmountInfos());
        Collections.reverse(awardAmountInfos);
        return awardAmountInfos.stream().filter(aai -> {
            if (aai.getTimeAndMoneyDocumentNumber() == null || aai.getAwardNumber().endsWith("-00001") && award.getAwardAmountInfos().indexOf(aai) == 1) {
                return true;
            }
            HashMap<String, String> fieldValues1 = new HashMap<String, String>();
            fieldValues1.put("documentNumber", aai.getTimeAndMoneyDocumentNumber());
            List timeAndMoneyDocuments = (List)this.getBusinessObjectService().findMatching(TimeAndMoneyDocument.class, fieldValues1);
            if (!timeAndMoneyDocuments.isEmpty()) {
                try {
                    TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)this.getDocumentService().getByDocumentHeaderId(((TimeAndMoneyDocument)timeAndMoneyDocuments.get(0)).getDocumentHeader().getDocumentNumber());
                    if (timeAndMoneyDocument.getDocumentHeader().hasWorkflowDocument() && timeAndMoneyDocument.getDocumentHeader().getWorkflowDocument().isFinal()) {
                        return true;
                    }
                }
                catch (WorkflowException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }).findFirst().get();
    }

    @Override
    public AwardAmountInfo fetchLastAwardAmountInfoForDocNum(Award award, String docNum) {
        ArrayList<AwardAmountInfo> validAwardAmountInfos = new ArrayList<AwardAmountInfo>();
        int docNumIntValue = Integer.parseInt(docNum.trim());
        for (AwardAmountInfo aai : award.getAwardAmountInfos()) {
            if (aai.getTimeAndMoneyDocumentNumber() == null || aai.getAwardNumber().endsWith("-00001") && award.getAwardAmountInfos().indexOf(aai) == 1) {
                validAwardAmountInfos.add(aai);
                continue;
            }
            if (Integer.parseInt(aai.getTimeAndMoneyDocumentNumber().trim()) > docNumIntValue) break;
            validAwardAmountInfos.add(aai);
        }
        return (AwardAmountInfo)validAwardAmountInfos.get(validAwardAmountInfos.size() - 1);
    }

    @Override
    public AwardAmountInfo fetchAwardAmountInfoWithHighestTransactionId(List<AwardAmountInfo> awardAmountInfos) {
        return awardAmountInfos.get(awardAmountInfos.size() - 1);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

