/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.kra.award.home.ValidAwardBasisPayment;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.award.service.AwardPaymentAndInvoicesService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardPaymentAndInvoicesServiceImpl
implements AwardPaymentAndInvoicesService {
    static final String AWARDTYPECODE = "awardTypeCode";
    static final String VALIDAWARDBASISPAYMENT_ID = "validAwardBasisPaymentId";
    static final String BASISOFPAYMENTCODE = "basisOfPaymentCode";
    static final String METHODOFPAYMENTCODE = "methodOfPaymentCode";
    BusinessObjectService businessObjectService;

    @Override
    public List<ValidAwardBasisPayment> getValidAwardBasisPaymentsByAwardTypeCode(Integer awardTypeCode) {
        ArrayList<ValidAwardBasisPayment> results = new ArrayList<ValidAwardBasisPayment>(this.businessObjectService.findMatchingOrderBy(ValidAwardBasisPayment.class, Collections.singletonMap(AWARDTYPECODE, awardTypeCode), VALIDAWARDBASISPAYMENT_ID, true));
        return results;
    }

    @Override
    public List<ValidBasisMethodPayment> getValidBasisMethodPaymentByBasisCode(String basisOfPaymentCode) {
        ArrayList<ValidBasisMethodPayment> results = new ArrayList<ValidBasisMethodPayment>(this.businessObjectService.findMatchingOrderBy(ValidBasisMethodPayment.class, Collections.singletonMap(BASISOFPAYMENTCODE, basisOfPaymentCode), METHODOFPAYMENTCODE, true));
        return results;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

