/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.w3c.dom.Element;

@XmlRootElement(name="requestedActions")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RequestedActionsType", propOrder={"completeRequested", "approveRequested", "acknowledgeRequested", "fyiRequested", "_futureElements"})
public final class RequestedActions
extends AbstractDataTransferObject {
    private static final long serialVersionUID = -6600754341497697330L;
    @XmlElement(name="completeRequested", required=true)
    private final boolean completeRequested;
    @XmlElement(name="approveRequested", required=true)
    private final boolean approveRequested;
    @XmlElement(name="acknowledgeRequested", required=true)
    private final boolean acknowledgeRequested;
    @XmlElement(name="fyiRequested", required=true)
    private final boolean fyiRequested;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RequestedActions() {
        this.completeRequested = false;
        this.approveRequested = false;
        this.acknowledgeRequested = false;
        this.fyiRequested = false;
    }

    private RequestedActions(boolean completeRequested, boolean approveRequested, boolean acknowledgeRequested, boolean fyiRequested) {
        this.completeRequested = completeRequested;
        this.approveRequested = approveRequested;
        this.acknowledgeRequested = acknowledgeRequested;
        this.fyiRequested = fyiRequested;
    }

    public static RequestedActions create(boolean completeRequested, boolean approveRequested, boolean acknowledgeRequested, boolean fyiRequested) {
        return new RequestedActions(completeRequested, approveRequested, acknowledgeRequested, fyiRequested);
    }

    public boolean isCompleteRequested() {
        return this.completeRequested;
    }

    public boolean isApproveRequested() {
        return this.approveRequested;
    }

    public boolean isAcknowledgeRequested() {
        return this.acknowledgeRequested;
    }

    public boolean isFyiRequested() {
        return this.fyiRequested;
    }

    public Set<ActionRequestType> getRequestedActions() {
        EnumSet<ActionRequestType> requestedActions = EnumSet.noneOf(ActionRequestType.class);
        if (this.isCompleteRequested()) {
            requestedActions.add(ActionRequestType.COMPLETE);
        }
        if (this.isApproveRequested()) {
            requestedActions.add(ActionRequestType.APPROVE);
        }
        if (this.isAcknowledgeRequested()) {
            requestedActions.add(ActionRequestType.ACKNOWLEDGE);
        }
        if (this.isFyiRequested()) {
            requestedActions.add(ActionRequestType.FYI);
        }
        return Collections.unmodifiableSet(requestedActions);
    }

    public boolean contains(ActionRequestType actionRequestType) {
        if (actionRequestType == null) {
            throw new IllegalArgumentException("actionRequestType was null");
        }
        return this.getRequestedActions().contains((Object)actionRequestType);
    }

    static class Elements {
        static final String COMPLETE_REQUESTED = "completeRequested";
        static final String APPROVE_REQUESTED = "approveRequested";
        static final String ACKNOWLEDGE_REQUESTED = "acknowledgeRequested";
        static final String FYI_REQUESTED = "fyiRequested";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "requestedActions";
        static final String TYPE_NAME = "RequestedActionsType";

        Constants() {
        }
    }
}

