/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.doctype;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.doctype.ProcessDefinitionContract;
import org.kuali.rice.kew.api.doctype.RouteNode;
import org.kuali.rice.kew.api.doctype.RouteNodeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="process")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ProcessType", propOrder={"id", "name", "documentTypeId", "initialRouteNode", "initial", "versionNumber", "_futureElements"})
public final class ProcessDefinition
extends AbstractDataTransferObject
implements ProcessDefinitionContract {
    private static final long serialVersionUID = 1076976038764944504L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="documentTypeId", required=false)
    private final String documentTypeId;
    @XmlElement(name="initialRouteNode", required=false)
    private final RouteNode initialRouteNode;
    @XmlElement(name="initial", required=true)
    private final boolean initial;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ProcessDefinition() {
        this.id = null;
        this.name = null;
        this.documentTypeId = null;
        this.initialRouteNode = null;
        this.initial = false;
        this.versionNumber = null;
    }

    private ProcessDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.documentTypeId = builder.getDocumentTypeId();
        this.initialRouteNode = builder.getInitialRouteNode() != null ? builder.getInitialRouteNode().build() : null;
        this.initial = builder.isInitial();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    @Override
    public RouteNodeContract getInitialRouteNode() {
        return this.initialRouteNode;
    }

    @Override
    public boolean isInitial() {
        return this.initial;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String DOCUMENT_TYPE_ID = "documentTypeId";
        static final String INITIAL_ROUTE_NODE = "initialRouteNode";
        static final String INITIAL = "initial";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "process";
        static final String TYPE_NAME = "ProcessType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    ProcessDefinitionContract {
        private static final long serialVersionUID = 5897271312287857808L;
        private String id;
        private String name;
        private String documentTypeId;
        private RouteNode.Builder initialRouteNode;
        private boolean initial;
        private Long versionNumber;

        private Builder(String name, RouteNode.Builder initialRouteNode, boolean initial) {
            this.setName(name);
            this.setInitialRouteNode(initialRouteNode);
            this.setInitial(initial);
        }

        public static Builder create(String name, RouteNode.Builder initialRouteNode, boolean initial) {
            return new Builder(name, initialRouteNode, initial);
        }

        public static Builder create(ProcessDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            RouteNode.Builder initialRouteNode = null;
            if (contract.getInitialRouteNode() != null) {
                initialRouteNode = RouteNode.Builder.create(contract.getInitialRouteNode());
            }
            Builder builder = Builder.create(contract.getName(), initialRouteNode, contract.isInitial());
            builder.setDocumentTypeId(contract.getDocumentTypeId());
            builder.setId(contract.getId());
            return builder;
        }

        public ProcessDefinition build() {
            return new ProcessDefinition(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDocumentTypeId() {
            return this.documentTypeId;
        }

        @Override
        public RouteNode.Builder getInitialRouteNode() {
            return this.initialRouteNode;
        }

        @Override
        public boolean isInitial() {
            return this.initial;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was null or blank");
            }
            this.name = name;
        }

        public void setDocumentTypeId(String documentTypeId) {
            this.documentTypeId = documentTypeId;
        }

        public void setInitialRouteNode(RouteNode.Builder initialRouteNode) {
            this.initialRouteNode = initialRouteNode;
        }

        public void setInitial(boolean initial) {
            this.initial = initial;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }
    }
}

