/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.framework.util.ApplicationThreadLocal;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;

public class ApplicationThreadLocalCleaner
implements ApplicationContextAware {
    private static final Logger LOG = LogManager.getLogger(ApplicationThreadLocalCleaner.class);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
            context.addApplicationListener((ApplicationListener)new ApplicationListener<ContextClosedEvent>(){

                public void onApplicationEvent(ContextClosedEvent e) {
                    LOG.info("Context '" + e.getApplicationContext().getDisplayName() + "' closed, removing registered ApplicationThreadLocals");
                    if (!ApplicationThreadLocal.clear()) {
                        LOG.error("Error(s) occurred removing registered ApplicationThreadLocals");
                    }
                }
            });
        }
    }
}

