/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.exception;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.exception.SeverityEnum;

public abstract class BaseNestableRuntimeException
extends RuntimeException {
    private final Class sourceClass;
    private Throwable nestedException;

    public BaseNestableRuntimeException(Class source, String message) {
        super(message);
        this.sourceClass = source;
        Log log = LogFactory.getLog((Class)source);
        if (this.getSeverity() == SeverityEnum.DEBUG) {
            log.debug((Object)this.toString());
        } else if (this.getSeverity() == SeverityEnum.INFO) {
            log.info((Object)this.toString());
        } else if (this.getSeverity() == SeverityEnum.WARN) {
            log.warn((Object)this.toString());
        } else {
            log.error((Object)this.toString());
        }
    }

    public BaseNestableRuntimeException(Class source, String message, Throwable cause) {
        super(message);
        this.sourceClass = source;
        this.nestedException = cause;
        Log log = LogFactory.getLog((Class)source);
        if (this.getSeverity() == SeverityEnum.DEBUG) {
            log.debug((Object)this.toString(), cause);
        } else if (this.getSeverity() == SeverityEnum.INFO) {
            log.info((Object)this.toString(), cause);
        } else if (this.getSeverity() == SeverityEnum.WARN) {
            log.warn((Object)this.toString(), cause);
        } else {
            log.error((Object)this.toString(), cause);
        }
    }

    public Throwable getCause() {
        return this.nestedException;
    }

    public String toString() {
        String className = this.sourceClass.getName();
        className = className.substring(className.lastIndexOf("."));
        if (this.nestedException == null) {
            return Messages.getString("NestableException.msg", new Object[]{className, this.getMessage()});
        }
        return Messages.getString("NestableException.msgcause", new Object[]{className, this.getMessage(), this.nestedException.getMessage()});
    }

    public abstract SeverityEnum getSeverity();
}

