/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;

class HtmlHeapHistogramReport
extends HtmlAbstractReport {
    private final HeapHistogram heapHistogram;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    HtmlHeapHistogramReport(HeapHistogram heapHistogram, Writer writer) {
        super(writer);
        assert (heapHistogram != null);
        this.heapHistogram = heapHistogram;
    }

    @Override
    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        String title = HtmlHeapHistogramReport.getFormattedString("heap_histo_du", I18N.createDateAndTimeFormat().format(this.heapHistogram.getTime()));
        this.writeTitle("memory.png", title);
        this.writeln("<br/><b>#Heap#</b>");
        String separator = "&nbsp;&nbsp;&nbsp;";
        this.writeln("&nbsp;&nbsp;&nbsp;");
        List<HeapHistogram.ClassInfo> heap = this.heapHistogram.getHeapHistogram();
        long totalHeapInstances = this.heapHistogram.getTotalHeapInstances();
        long totalHeapBytes = this.heapHistogram.getTotalHeapBytes();
        this.writeln("#Classes#: " + this.integerFormat.format(heap.size()) + ',');
        this.writeln("&nbsp;&nbsp;&nbsp;");
        this.writeln("#Instances#: " + this.integerFormat.format(totalHeapInstances) + ',');
        this.writeln("&nbsp;&nbsp;&nbsp;");
        this.writeln("#Kilo-Octets#: " + this.integerFormat.format(totalHeapBytes / 1024L));
        this.writeClassInfoSummaryAndDetails(heap, totalHeapInstances, totalHeapBytes, true, this.heapHistogram.isSourceDisplayed());
        List<HeapHistogram.ClassInfo> permGen = this.heapHistogram.getPermGenHistogram();
        if (!permGen.isEmpty()) {
            this.writeln("<br/><br/><b>#PermGen#</b>");
            this.writeln("&nbsp;&nbsp;&nbsp;");
            long totalPermGenInstances = this.heapHistogram.getTotalPermGenInstances();
            long totalPermGenBytes = this.heapHistogram.getTotalPermGenBytes();
            this.writeln("#Classes#: " + this.integerFormat.format(permGen.size()) + ',');
            this.writeln("&nbsp;&nbsp;&nbsp;");
            this.writeln("#Instances#: " + this.integerFormat.format(totalPermGenInstances) + ',');
            this.writeln("&nbsp;&nbsp;&nbsp;");
            this.writeln("#Kilo-Octets#: " + this.integerFormat.format(totalPermGenBytes / 1024L));
            this.writeClassInfoSummaryAndDetails(permGen, totalPermGenInstances, totalPermGenBytes, false, false);
        }
    }

    private void writeClassInfoSummaryAndDetails(List<HeapHistogram.ClassInfo> classHistogram, long totalInstances, long totalBytes, boolean heap, boolean sourceDisplayed) throws IOException {
        ArrayList<HeapHistogram.ClassInfo> summaryClassHistogram = new ArrayList<HeapHistogram.ClassInfo>();
        for (HeapHistogram.ClassInfo classInfo : classHistogram) {
            if (classInfo.getBytes() * 100L / totalBytes == 0L) break;
            summaryClassHistogram.add(classInfo);
        }
        this.writeClassInfo(summaryClassHistogram, totalInstances, totalBytes, heap, sourceDisplayed);
        this.writeln("<div align='right'>");
        String id = heap ? "detailsHeap" : "detailsPermGen";
        this.writeShowHideLink(id, "#Details#");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("</div><div id='" + id + "' style='display:none;'>");
        ArrayList<HeapHistogram.ClassInfo> detailsClassHistogram = new ArrayList<HeapHistogram.ClassInfo>();
        for (HeapHistogram.ClassInfo classInfo : classHistogram) {
            if (classInfo.getBytes() * 100L / totalBytes != 0L) continue;
            detailsClassHistogram.add(classInfo);
        }
        this.writeClassInfo(detailsClassHistogram, totalInstances, totalBytes, heap, sourceDisplayed);
        this.writeln("</div>");
    }

    private void writeClassInfo(List<HeapHistogram.ClassInfo> classHistogram, long totalInstances, long totalBytes, boolean heap, boolean sourceDisplayed) throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlHeapHistogramReport.getString("histogramme"));
        this.write("<th>#Classe#</th><th>#Taille#</th><th>#pct_taille#</th><th>#Instances#</th><th>#pct_instances#</th>" + (sourceDisplayed ? "<th>#Source#</th>" : ""));
        for (HeapHistogram.ClassInfo classInfo : classHistogram) {
            table.nextRow();
            this.writeClassInfoRow(classInfo, totalInstances, totalBytes, heap, sourceDisplayed);
        }
        table.endTable();
    }

    private void writeClassInfoRow(HeapHistogram.ClassInfo classInfo, long totalInstances, long totalBytes, boolean heap, boolean sourceDisplayed) throws IOException {
        this.writeDirectly("<td>");
        String classInfoName = classInfo.getName();
        if (heap) {
            this.writeDirectly(HtmlSourceReport.addLinkToClassName(classInfoName));
        } else {
            this.writeDirectly(classInfoName.replaceAll("[<]", "&lt;").replaceAll("[>]", "&gt;"));
        }
        String nextColumnAlignRight = "</td><td align='right'>";
        this.writeDirectly("</td><td align='right'>");
        long bytes = classInfo.getBytes();
        long instancesCount = classInfo.getInstancesCount();
        this.writeDirectly(this.integerFormat.format(bytes / 1024L));
        this.writeDirectly("</td><td align='right'>");
        this.writeDirectly(this.integerFormat.format(bytes * 100L / totalBytes));
        this.writeDirectly("</td><td align='right'>");
        this.writeDirectly(this.integerFormat.format(instancesCount));
        this.writeDirectly("</td><td align='right'>");
        this.writeDirectly(this.integerFormat.format(instancesCount * 100L / totalInstances));
        this.writeDirectly("</td>");
        if (sourceDisplayed) {
            this.writeDirectly("<td>");
            String source = classInfo.getSource();
            if (source == null) {
                this.writeDirectly("&nbsp;");
            } else {
                this.writeDirectly(source);
            }
            this.writeDirectly("</td>");
        }
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=heaphisto'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlHeapHistogramReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=heaphisto&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        if (Action.GC_ENABLED) {
            this.writeln("<a href='?part=heaphisto&amp;action=gc" + HtmlHeapHistogramReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + HtmlHeapHistogramReport.getStringForJavascript("confirm_ramasse_miette") + "');\">");
            this.writeln("<img src='?resource=broom.png' width='16' height='16' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        } else {
            this.writeln("<a href='?part=heaphisto&amp;action=gc" + HtmlHeapHistogramReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:alert('" + HtmlHeapHistogramReport.getStringForJavascript("ramasse_miette_desactive") + "');return false;\">");
            this.writeln("<img src='?resource=broom.png' width='16' height='16' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeln("<a href='?part=heaphisto&amp;action=heap_dump" + HtmlHeapHistogramReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + HtmlHeapHistogramReport.getStringForJavascript("confirm_heap_dump") + "');\">");
        this.writeln("<img src='?resource=heapdump.png' width='16' height='16' alt='#heap_dump#' /> #heap_dump#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("</div>");
    }
}

