/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.web.spring;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kcb.bo.RecipientDelivererConfig;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;
import org.kuali.rice.kcb.service.KENIntegrationService;
import org.kuali.rice.kcb.service.MessageDelivererRegistryService;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.kns.util.WebUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class UserPreferencesController
extends MultiActionController {
    private static final Logger LOG = LogManager.getLogger(UserPreferencesController.class);
    private static final String VIEW = "DelivererPreferences";
    private static final String KEW_CHANNEL = "KEW";
    protected RecipientPreferenceService recipientPreferenceService;
    protected MessageDelivererRegistryService messageDelivererRegistryService;
    protected KENIntegrationService kenIntegrationService;

    @Required
    public void setRecipientPreferenceService(RecipientPreferenceService userPreferenceService) {
        this.recipientPreferenceService = userPreferenceService;
    }

    @Required
    public void setMessageDelivererRegistryService(MessageDelivererRegistryService messageDelivererRegistryService) {
        this.messageDelivererRegistryService = messageDelivererRegistryService;
    }

    @Required
    public void setKenIntegrationService(KENIntegrationService kis) {
        this.kenIntegrationService = kis;
    }

    protected Collection<String> getAllChannels() {
        ArrayList<String> allChannels = new ArrayList<String>();
        allChannels.addAll(this.kenIntegrationService.getAllChannelNames());
        return allChannels;
    }

    public ModelAndView displayDelivererConfigurationForm(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userid = request.getRemoteUser();
        LOG.debug("remoteUser: " + userid);
        Collection<MessageDeliverer> deliveryTypes = this.messageDelivererRegistryService.getAllDeliverers();
        Collection<String> channels = this.getAllChannels();
        HashMap<String, String> preferences = this.recipientPreferenceService.getRecipientPreferences(userid);
        Collection<RecipientDelivererConfig> currentDeliverers = this.recipientPreferenceService.getDeliverersForRecipient(userid);
        HashMap<CallSite, Boolean> currentDeliverersMap = new HashMap<CallSite, Boolean>();
        for (RecipientDelivererConfig udc : currentDeliverers) {
            String channelName = udc.getChannel();
            currentDeliverersMap.put((CallSite)((Object)(udc.getDelivererName() + "." + channelName)), Boolean.TRUE);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("deliveryTypes", deliveryTypes);
        model.put("preferences", preferences);
        model.put("currentDeliverersMap", currentDeliverersMap);
        this.putBackLocation(model, request.getParameter("backLocation"));
        return new ModelAndView(VIEW, model);
    }

    private void putBackLocation(Map<String, Object> model, String backLocation) {
        if (StringUtils.isNotBlank((String)backLocation)) {
            model.put("backLocation", WebUtils.sanitizeBackLocation((String)backLocation));
        }
    }

    public ModelAndView saveDelivererConfiguration(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userid = request.getRemoteUser();
        LOG.debug("remoteUser: " + userid);
        boolean error = false;
        HashMap<String, Object> model = new HashMap<String, Object>();
        HashMap<CallSite, String> preferences = new HashMap<CallSite, String>();
        Collection<MessageDeliverer> deliveryTypes = this.messageDelivererRegistryService.getAllDeliverers();
        this.recipientPreferenceService.removeRecipientDelivererConfigs(userid);
        for (MessageDeliverer dt : deliveryTypes) {
            String deliveryTypeName = dt.getName();
            LinkedHashMap<String, String> prefMap = dt.getPreferenceKeys();
            LOG.debug("deliveryName: " + deliveryTypeName);
            HashMap<String, String> userprefs = new HashMap<String, String>();
            for (String prefKey : ((HashMap)prefMap).keySet()) {
                LOG.debug("   key: " + prefKey + ", value: " + request.getParameter(deliveryTypeName + "." + prefKey));
                userprefs.put(deliveryTypeName + "." + prefKey, request.getParameter(deliveryTypeName + "." + prefKey));
                preferences.put((CallSite)((Object)(deliveryTypeName + "." + prefKey)), request.getParameter(deliveryTypeName + "." + prefKey));
            }
            try {
                this.recipientPreferenceService.saveRecipientPreferences(userid, userprefs, dt);
            }
            catch (ErrorList errorlist) {
                error = true;
                model.put("errorList", errorlist.getErrors());
            }
            String[] channels = request.getParameterValues(deliveryTypeName + ".channels");
            if (channels != null && channels.length > 0) {
                for (int j = 0; j < channels.length; ++j) {
                    LOG.debug(deliveryTypeName + ".channels[" + j + "] " + channels[j]);
                }
            }
            this.recipientPreferenceService.saveRecipientDelivererConfig(userid, deliveryTypeName, channels);
        }
        Collection<String> channels = this.getAllChannels();
        Collection<RecipientDelivererConfig> currentDeliverers = this.recipientPreferenceService.getDeliverersForRecipient(userid);
        HashMap<CallSite, Boolean> currentDeliverersMap = new HashMap<CallSite, Boolean>();
        for (RecipientDelivererConfig udc : currentDeliverers) {
            String channelId = udc.getChannel();
            currentDeliverersMap.put((CallSite)((Object)(udc.getDelivererName() + "." + channelId)), Boolean.TRUE);
        }
        model.put("channels", channels);
        model.put("deliveryTypes", deliveryTypes);
        model.put("preferences", preferences);
        model.put("currentDeliverersMap", currentDeliverersMap);
        model.put("message", "Update Successful");
        this.putBackLocation(model, request.getParameter("backLocation"));
        return new ModelAndView(VIEW, model);
    }
}

